/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.tstore.compaction.CompactorMetrics;

public class HybridLogImplMetrics {
    private static final int INIT_VALUE = -1;
    private static final double HUNDRED = 100.0;
    private final long initNanos = System.nanoTime();
    private volatile long totalPageWrites;
    @Probe(name="tstore.hlog.pageWriteDuration.avg", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long pageWriteDurationAvgNs = -1L;
    @Probe(name="tstore.hlog.pageWriteDuration.min", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long pageWriteDurationMinNs = -1L;
    @Probe(name="tstore.hlog.pageWriteDuration.max", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long pageWriteDurationMaxNs = -1L;
    @Probe(name="tstore.hlog.pageWriteDuration.total", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long pageWriteDurationTotalNs = -1L;
    private volatile long totalRecordsRead;
    @Probe(name="tstore.hlog.readRecordDuration.avg", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long readRecordDurationAvgNs = -1L;
    @Probe(name="tstore.hlog.readRecordDuration.min", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long readRecordDurationMinNs = -1L;
    @Probe(name="tstore.hlog.readRecordDuration.max", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long readRecordDurationMaxNs = -1L;
    @Probe(name="tstore.hlog.readRecordDuration.total", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long readRecordDurationTotalNs = -1L;
    @Probe(name="tstore.hlog.readRecord.hits", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long readRecordHits;
    @Probe(name="tstore.hlog.readRecord.hit.percent", unit=ProbeUnit.PERCENT, level=ProbeLevel.DEBUG)
    private volatile double readRecordHitPercent;
    @Probe(name="tstore.hlog.readRecord.misses", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long readRecordMisses;
    @Probe(name="tstore.hlog.readRecord.miss.percent", unit=ProbeUnit.PERCENT, level=ProbeLevel.DEBUG)
    private volatile double readRecordMissesPercent;
    @Probe(name="tstore.hlog.allocation.stall.avg", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long allocationStallAvgNs = -1L;
    @Probe(name="tstore.hlog.allocation.stall.min", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long allocationStallMinNs = -1L;
    @Probe(name="tstore.hlog.allocation.stall.max", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long allocationStallMaxNs = -1L;
    @Probe(name="tstore.hlog.allocation.stall.total", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long allocationStallTotalNs = -1L;
    private volatile long totalAllocationStalls;
    private volatile long totalAllocations;
    private volatile long totalPageAllocations;
    @Probe(name="tstore.hlog.allocation.size.avg", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long allocationSizeAvg = -1L;
    @Probe(name="tstore.hlog.allocation.size.min", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long allocationSizeMin = -1L;
    @Probe(name="tstore.hlog.allocation.size.max", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long allocationSizeMax = -1L;
    @Probe(name="tstore.hlog.allocation.size.total", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long allocationSizeTotal;
    @Probe(name="tstore.hlog.waste.alignment.avg", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wasteAlignmentAvg = -1L;
    @Probe(name="tstore.hlog.waste.alignment.min", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wasteAlignmentMin = -1L;
    @Probe(name="tstore.hlog.waste.alignment.max", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wasteAlignmentMax = -1L;
    @Probe(name="tstore.hlog.waste.alignment.total", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wasteAlignmentTotal;
    @Probe(name="tstore.hlog.waste.paging.avg", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wastePagingAvg = -1L;
    @Probe(name="tstore.hlog.waste.paging.min", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wastePagingMin = -1L;
    @Probe(name="tstore.hlog.waste.paging.max", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wastePagingMax = -1L;
    @Probe(name="tstore.hlog.waste.paging.total", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long wastePagingTotal;
    @Probe(name="tstore.hlog.allocation.per.page.avg", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long allocationPerPageAvg;
    @Probe(name="tstore.hlog.allocation.per.page.min", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long allocationPerPageMin = -1L;
    @Probe(name="tstore.hlog.allocation.per.page.max", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long allocationPerPageMax = -1L;
    @Probe(name="tstore.hlog.paging.frequency.avg", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long pagingFrequencyAvg = -1L;
    @Probe(name="tstore.hlog.paging.frequency.min", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long pagingFrequencyMin = -1L;
    @Probe(name="tstore.hlog.paging.frequency.max", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long pagingFrequencyMax = -1L;
    private volatile long pageOpenNanos = System.nanoTime();
    private volatile long pageCount;
    @Probe(name="tstore.hlog.compaction.queueTime.total", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionQueueTimeTotalNs;
    @Probe(name="tstore.hlog.compaction.queueTime.min", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionQueueTimeMinNs = -1L;
    @Probe(name="tstore.hlog.compaction.queueTime.max", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionQueueTimeMaxNs = -1L;
    @Probe(name="tstore.hlog.compaction.queueTime.avg", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionQueueTimeAvgNs = -1L;
    @Probe(name="tstore.hlog.compaction.queue.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long compactionsQueued;
    @Probe(name="tstore.hlog.compaction.time.total", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionTimeTotalNs;
    @Probe(name="tstore.hlog.compaction.time.min", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionTimeMinNs = -1L;
    @Probe(name="tstore.hlog.compaction.time.max", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionTimeMaxNs = -1L;
    @Probe(name="tstore.hlog.compaction.time.avg", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionTimeAvgNs = -1L;
    @Probe(name="tstore.hlog.compaction.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long compactionsFinished;
    @Probe(name="tstore.hlog.compaction.failed.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long compactionsFailed;
    @Probe(name="tstore.hlog.compaction.inProgress.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long compactionsInProgress;
    @Probe(name="tstore.hlog.compaction.dummyRecords.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long dummyRecordsCnt;
    @Probe(name="tstore.hlog.compaction.dummyRecords.size", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long dummyRecordsSize;
    @Probe(name="tstore.hlog.compaction.nonDummyRecords.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long nonDummyRecordsCnt;
    @Probe(name="tstore.hlog.compaction.nonDummyRecords.size", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long nonDummyRecordsSize;
    @Probe(name="tstore.hlog.compaction.aliveRecords.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long aliveRecordsCnt;
    @Probe(name="tstore.hlog.compaction.aliveRecords.size", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long aliveRecordsSize;
    @Probe(name="tstore.hlog.compaction.deadRecords.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long deadRecordsCnt;
    @Probe(name="tstore.hlog.compaction.deadRecords.size", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long deadRecordsSize;
    @Probe(name="tstore.hlog.compaction.visitedRecords.count", unit=ProbeUnit.COUNT, level=ProbeLevel.DEBUG)
    private volatile long visitedRecordsCnt;
    @Probe(name="tstore.hlog.compaction.visitedRecords.size", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private volatile long visitedRecordsSize;
    @Probe(name="tstore.hlog.compaction.ioTime.total", unit=ProbeUnit.NS, level=ProbeLevel.DEBUG)
    private volatile long compactionIoTimeTotalNs;

    void onPageWritten(long startNanos) {
        long durationNs = HybridLogImplMetrics.durationNsSince(startNanos);
        if (durationNs < this.pageWriteDurationMinNs || this.pageWriteDurationMinNs == -1L) {
            this.pageWriteDurationMinNs = durationNs;
        }
        if (durationNs > this.pageWriteDurationMaxNs) {
            this.pageWriteDurationMaxNs = durationNs;
        }
        this.pageWriteDurationAvgNs = (this.totalPageWrites * this.pageWriteDurationAvgNs + durationNs) / (this.totalPageWrites + 1L);
        this.pageWriteDurationTotalNs += durationNs;
        ++this.totalPageWrites;
    }

    private static long durationNsSince(long startNanos) {
        return System.nanoTime() - startNanos;
    }

    void onRecordReadFromDeviceCompleted(long startNanos) {
        long durationNs = HybridLogImplMetrics.durationNsSince(startNanos);
        if (durationNs < this.readRecordDurationMinNs || this.readRecordDurationMinNs == -1L) {
            this.readRecordDurationMinNs = durationNs;
        }
        if (durationNs > this.readRecordDurationMaxNs) {
            this.readRecordDurationMaxNs = durationNs;
        }
        long totalRecordsReadCopy = this.totalRecordsRead + 1L;
        long readRecordDurationAvgNsCopy = this.readRecordDurationAvgNs;
        this.readRecordDurationAvgNs = (readRecordDurationAvgNsCopy + durationNs) / totalRecordsReadCopy;
        this.readRecordDurationTotalNs += durationNs;
        this.totalRecordsRead = totalRecordsReadCopy;
    }

    void onReadRecordHit() {
        this.onReadRecordHit(true);
    }

    void onReadRecordMiss() {
        this.onReadRecordHit(false);
    }

    private void onReadRecordHit(boolean hit) {
        double newReadRecordHitPercent;
        long readRecordHitsCopy = this.readRecordHits;
        long readRecordMissesCopy = this.readRecordMisses;
        if (hit) {
            ++readRecordHitsCopy;
        } else {
            ++readRecordMissesCopy;
        }
        this.readRecordHitPercent = newReadRecordHitPercent = (double)readRecordHitsCopy / (double)(readRecordHitsCopy + readRecordMissesCopy);
        this.readRecordMissesPercent = 100.0 - newReadRecordHitPercent;
        this.readRecordHits = readRecordHitsCopy;
        this.readRecordMisses = readRecordMissesCopy;
    }

    void onAllocationStall(long startNanos) {
        long durationNs = HybridLogImplMetrics.durationNsSince(startNanos);
        if (durationNs < this.allocationStallMinNs || this.allocationStallMinNs == -1L) {
            this.allocationStallMinNs = durationNs;
        }
        if (durationNs > this.allocationStallMaxNs) {
            this.allocationStallMaxNs = durationNs;
        }
        long totalAllocationStallsCopy = this.totalAllocationStalls + 1L;
        long allocationStallTotalNsCopy = this.allocationStallTotalNs + durationNs;
        this.allocationStallAvgNs = allocationStallTotalNsCopy / totalAllocationStallsCopy;
        this.totalAllocationStalls = totalAllocationStallsCopy;
        this.allocationStallTotalNs = allocationStallTotalNsCopy;
    }

    void onPaging(int newPage, int wastedBytes) {
        long pageOpenNanosCopy = this.pageOpenNanos;
        long newPageOpenNanos = System.nanoTime();
        long pagingFrequencyNs = newPageOpenNanos - pageOpenNanosCopy;
        this.pageOpenNanos = newPageOpenNanos;
        int totalPaging = newPage - 1;
        long totalPageAllocationsCopy = this.totalPageAllocations + 1L;
        this.totalPageAllocations = 0L;
        if (totalPaging == 0) {
            return;
        }
        this.recordPagingFrequency(totalPaging, pagingFrequencyNs);
        this.recordWaste(totalPaging, wastedBytes);
        this.recordPageAllocations(totalPaging, totalPageAllocationsCopy);
        this.pageCount = newPage;
    }

    private void recordPageAllocations(int totalPaging, long pageAllocations) {
        if (pageAllocations < this.allocationPerPageMin || this.allocationPerPageMin == -1L) {
            this.allocationPerPageMin = pageAllocations;
        }
        if (pageAllocations > this.allocationPerPageMax) {
            this.allocationPerPageMax = pageAllocations;
        }
        this.allocationPerPageAvg = ((long)(totalPaging - 1) * this.allocationPerPageAvg + pageAllocations) / (long)totalPaging;
    }

    private void recordWaste(long totalPagingLocal, int wastedBytes) {
        if ((long)wastedBytes < this.wastePagingMin || this.wastePagingMin == -1L) {
            this.wastePagingMin = wastedBytes;
        }
        if ((long)wastedBytes > this.wastePagingMax) {
            this.wastePagingMax = wastedBytes;
        }
        long wastePagingTotalLocal = this.wastePagingTotal + (long)wastedBytes;
        this.wastePagingAvg = wastePagingTotalLocal / totalPagingLocal;
        this.wastePagingTotal = wastePagingTotalLocal;
    }

    private void recordPagingFrequency(long totalPagingLocal, long pagingFrequencyNs) {
        if (pagingFrequencyNs < this.pagingFrequencyMin || this.pagingFrequencyMin == -1L) {
            this.pagingFrequencyMin = pagingFrequencyNs;
        }
        if (pagingFrequencyNs > this.pagingFrequencyMax) {
            this.pagingFrequencyMax = pagingFrequencyNs;
        }
        this.pagingFrequencyAvg = HybridLogImplMetrics.durationNsSince(this.initNanos) / totalPagingLocal;
    }

    public void onAllocation(int size, int paddedSize) {
        int wastedBytes = paddedSize - size;
        long totalAllocationsLocal = this.totalAllocations + 1L;
        this.recordAllocationSize(paddedSize, totalAllocationsLocal);
        this.recordAlignmentWaste(wastedBytes, totalAllocationsLocal);
        ++this.totalPageAllocations;
        this.totalAllocations = totalAllocationsLocal;
    }

    private void recordAllocationSize(int size, long totalAllocationsLocal) {
        if ((long)size < this.allocationSizeMin || this.allocationSizeMin == -1L) {
            this.allocationSizeMin = size;
        }
        if ((long)size > this.allocationSizeMax) {
            this.allocationSizeMax = size;
        }
        long allocationSizeTotalLocal = this.allocationSizeTotal + (long)size;
        this.allocationSizeAvg = allocationSizeTotalLocal / totalAllocationsLocal;
        this.allocationSizeTotal = allocationSizeTotalLocal;
    }

    private void recordAlignmentWaste(int wastedBytes, long totalAllocationsLocal) {
        if ((long)wastedBytes < this.wasteAlignmentMin || this.wasteAlignmentMin == -1L) {
            this.wasteAlignmentMin = wastedBytes;
        }
        if ((long)wastedBytes > this.wasteAlignmentMax) {
            this.wasteAlignmentMax = wastedBytes;
        }
        this.wasteAlignmentTotal += (long)wastedBytes;
        this.wasteAlignmentAvg = this.wasteAlignmentTotal / totalAllocationsLocal;
    }

    public long getHybridLogLengthTotal() {
        return this.allocationSizeTotal + this.wastePagingTotal + this.pageCount * 8L;
    }

    public void onCompactionQueued() {
        ++this.compactionsQueued;
    }

    public void onCompactionStart(long queuedAtNanos) {
        --this.compactionsQueued;
        ++this.compactionsInProgress;
        long queuedNs = HybridLogImplMetrics.durationNsSince(queuedAtNanos);
        this.compactionQueueTimeTotalNs += queuedNs;
        if (this.compactionQueueTimeMinNs == -1L || queuedNs < this.compactionQueueTimeMinNs) {
            this.compactionQueueTimeMinNs = queuedNs;
        }
        if (queuedNs > this.compactionQueueTimeMaxNs) {
            this.compactionQueueTimeMaxNs = queuedNs;
        }
        this.compactionQueueTimeAvgNs = this.compactionQueueTimeTotalNs / (this.compactionsInProgress + this.compactionsFinished);
    }

    public void onCompactionFinish(CompactorMetrics metrics, boolean error) {
        --this.compactionsInProgress;
        ++this.compactionsFinished;
        if (error) {
            ++this.compactionsFailed;
        }
        this.dummyRecordsCnt += metrics.getDummyRecordsCnt();
        this.dummyRecordsSize += metrics.getDummyRecordsSize();
        this.nonDummyRecordsCnt += metrics.getNonDummyRecordsCnt();
        this.nonDummyRecordsSize += metrics.getNonDummyRecordsSize();
        this.aliveRecordsCnt += metrics.getAliveRecordsCnt();
        this.aliveRecordsSize += metrics.getAliveRecordsSize();
        this.deadRecordsCnt += metrics.getDeadRecordsCnt();
        this.deadRecordsSize += metrics.getDeadRecordsSize();
        this.visitedRecordsCnt += metrics.getVisitedRecordsCnt();
        this.visitedRecordsSize += metrics.getVisitedRecordsSize();
        long thisCompactionTimeNs = metrics.getCompactionTimeNs();
        this.compactionTimeTotalNs += thisCompactionTimeNs;
        if (this.compactionTimeMinNs == -1L || thisCompactionTimeNs < this.compactionTimeMinNs) {
            this.compactionTimeMinNs = thisCompactionTimeNs;
        }
        if (thisCompactionTimeNs > this.compactionTimeMaxNs) {
            this.compactionTimeMaxNs = thisCompactionTimeNs;
        }
        this.compactionTimeAvgNs = this.compactionTimeTotalNs / this.compactionsFinished;
        this.compactionIoTimeTotalNs += metrics.getIoTimeNanos();
    }

    long getPageWriteDurationTotalNs() {
        return this.pageWriteDurationTotalNs;
    }

    long getReadRecordDurationTotalNs() {
        return this.readRecordDurationTotalNs;
    }

    long getReadRecordHits() {
        return this.readRecordHits;
    }

    long getReadRecordMisses() {
        return this.readRecordMisses;
    }

    long getTotalAllocationStalls() {
        return this.totalAllocationStalls;
    }

    long getAllocationStallTotalNs() {
        return this.allocationStallTotalNs;
    }

    long getTotalAllocations() {
        return this.totalAllocations;
    }

    long getAllocationSizeTotal() {
        return this.allocationSizeTotal;
    }

    long getWasteAlignmentTotal() {
        return this.wasteAlignmentTotal;
    }

    long getWastePagingTotal() {
        return this.wastePagingTotal;
    }

    long getCompactionQueueTimeAvgNs() {
        return this.compactionQueueTimeAvgNs;
    }

    long getCompactionsQueued() {
        return this.compactionsQueued;
    }

    long getCompactionTimeTotalNs() {
        return this.compactionTimeTotalNs;
    }

    long getCompactionIoTimeTotalNs() {
        return this.compactionIoTimeTotalNs;
    }

    long getCompactionsFinished() {
        return this.compactionsFinished;
    }

    long getCompactionsInProgress() {
        return this.compactionsInProgress;
    }

    long getDummyRecordsCnt() {
        return this.dummyRecordsCnt;
    }

    long getDummyRecordsSize() {
        return this.dummyRecordsSize;
    }

    long getNonDummyRecordsCnt() {
        return this.nonDummyRecordsCnt;
    }

    long getNonDummyRecordsSize() {
        return this.nonDummyRecordsSize;
    }

    long getAliveRecordsCnt() {
        return this.aliveRecordsCnt;
    }

    long getAliveRecordsSize() {
        return this.aliveRecordsSize;
    }

    long getDeadRecordsCnt() {
        return this.deadRecordsCnt;
    }

    long getDeadRecordsSize() {
        return this.deadRecordsSize;
    }

    long getVisitedRecordsCnt() {
        return this.visitedRecordsCnt;
    }

    long getVisitedRecordsSize() {
        return this.visitedRecordsSize;
    }

    public long getPageCount() {
        return this.pageCount;
    }
}

