/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.MutableOperation;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.device.local.LocalStorageDeviceMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;

final class WriteOperation
extends MutableOperation {
    private final long logicalAddress;
    private final long pAddress;
    private final int writeLength;

    WriteOperation(Device device, long logicalAddress, long pAddress, int writeLength) {
        super(device);
        this.logicalAddress = logicalAddress;
        this.pAddress = pAddress;
        this.writeLength = writeLength;
    }

    private LocalStorageDevice getDevice() {
        return (LocalStorageDevice)this.device;
    }

    private LocalStorageDeviceMetrics getMetrics() {
        return (LocalStorageDeviceMetrics)this.getDevice().getMetrics();
    }

    @Override
    public Void run(byte[] context) {
        HybridLogFileHandleProvider handleProvider;
        int deviceId;
        if (this.writeLength != context.length) {
            throw new DeviceException(String.format("Buffer passed down does not have same length as writeLength. We run danger of missing some writes or overwriting. writeLength=%d, context.length=%d", this.writeLength, context.length));
        }
        long filePos = this.getDevice().getLogFileOffsetFromLogicalAddress(this.logicalAddress);
        int fileNo = this.getDevice().segmentNoOf(this.logicalAddress);
        HybridLogFileHandlePool handlePool = this.getDevice().getHandlePool();
        HybridLogFileHandle handle = handlePool.getHandle(deviceId = this.getDevice().getDeviceId(), fileNo, handleProvider = this.getDevice().getHandleProvider());
        if (handle == null) {
            throw new DeviceException("Cannot get handle for logical address");
        }
        try {
            byte[] buf = context;
            GlobalMemoryAccessorRegistry.AMEM.copyToByteArray(this.pAddress, buf, 0, this.writeLength);
            RandomAccessFile raf = handle.getRaf();
            raf.seek(filePos);
            raf.write(buf);
            this.getMetrics().onWrite(buf.length);
        }
        catch (IOException ioe) {
            throw new DeviceException(ioe);
        }
        finally {
            handlePool.releaseHandle(handle);
        }
        return null;
    }

    @Override
    public String toString() {
        return "WriteOperation(" + this.device.deviceName() + ", " + this.logicalAddress + ", " + this.pAddress + ", " + this.writeLength + ")";
    }
}

