/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HybridLogFileHandle {
    private static final ILogger LOGGER = Logger.getLogger(HybridLogFileHandle.class);
    private final File file;
    private final RandomAccessFile raf;
    private final int deviceId;
    private final int fileNo;

    public HybridLogFileHandle(File file, RandomAccessFile raf, int deviceId, int fileNo) {
        this.file = file;
        this.raf = raf;
        this.deviceId = deviceId;
        this.fileNo = fileNo;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public int getFileNo() {
        return this.fileNo;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String getAbsoluteFileName() {
        return this.file.getAbsolutePath();
    }

    File getFile() {
        return this.file;
    }

    void close() {
        try {
            this.raf.close();
        }
        catch (IOException ioe) {
            LOGGER.warning(String.format("Close failed for log file %s", this.file.getPath()), ioe);
        }
    }

    public String toString() {
        return "HybridLogHandle(" + this.deviceId + ", " + this.fileNo + ")";
    }
}

