/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.tstore.device.DeviceOperation;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutor;
import com.hazelcast.internal.tstore.device.ImmutableOperation;
import com.hazelcast.internal.tstore.device.MutableOperation;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;

public final class DeviceOperationExecutorImpl
implements DeviceOperationExecutor {
    static final String READER_THREAD_POOL_NAME_FORMAT = "tiered.store.device.reader.[%s]";
    static final String WRITER_THREAD_POOL_NAME_FORMAT = "tiered.store.device.writer.[%s]";
    private static final ILogger LOGGER = Logger.getLogger(DeviceOperationExecutorImpl.class);
    private final DeviceWriter[] writeIoThreads;
    private final DeviceReader[] readIoThreads;
    private final BlockingQueue<MutableOperation> writeQueue;
    private final BlockingQueue<ImmutableOperation> readQueue;
    private final int writePageSize;
    private final int readPageSize;

    public DeviceOperationExecutorImpl(int writeIOThreadCount, int readIOThreadCount, int readPageSize, int writePageSize, String deviceName, String hzName) {
        String threadName;
        int threadId;
        assert (writeIOThreadCount > 0 && readIOThreadCount > 0);
        assert (writePageSize > 0);
        assert (deviceName != null);
        this.writeIoThreads = new DeviceWriter[writeIOThreadCount];
        this.readIoThreads = new DeviceReader[readIOThreadCount];
        this.writeQueue = new LinkedBlockingQueue<MutableOperation>();
        this.readQueue = new LinkedBlockingQueue<ImmutableOperation>();
        this.readPageSize = readPageSize;
        this.writePageSize = writePageSize;
        for (threadId = 0; threadId < writeIOThreadCount; ++threadId) {
            threadName = ThreadUtil.createThreadPoolName(hzName, String.format(WRITER_THREAD_POOL_NAME_FORMAT, deviceName)) + threadId;
            DeviceWriter deviceWriter = new DeviceWriter(threadName);
            deviceWriter.start();
            this.writeIoThreads[threadId] = deviceWriter;
        }
        for (threadId = 0; threadId < readIOThreadCount; ++threadId) {
            threadName = ThreadUtil.createThreadPoolName(hzName, String.format(READER_THREAD_POOL_NAME_FORMAT, deviceName)) + threadId;
            DeviceReader reader = new DeviceReader(threadName);
            reader.start();
            this.readIoThreads[threadId] = reader;
        }
    }

    @Override
    public <R> CompletableFuture<R> submit(DeviceOperation<R> op) {
        BlockingQueue<DeviceOperation> queue = op instanceof MutableOperation ? this.writeQueue : this.readQueue;
        queue.offer(op);
        return op.getFuture();
    }

    @Override
    public void shutdown() {
        Arrays.stream(this.writeIoThreads).forEach(DeviceThread::terminate);
        Arrays.stream(this.readIoThreads).forEach(DeviceThread::terminate);
    }

    private final class DeviceWriter
    extends DeviceThread {
        private final byte[] pageData;

        DeviceWriter(String threadName) {
            super(threadName);
            this.pageData = new byte[DeviceOperationExecutorImpl.this.writePageSize];
        }

        @Override
        DeviceOperation takeOperation() throws InterruptedException {
            return DeviceOperationExecutorImpl.this.writeQueue.take();
        }

        @Override
        void executeOp(DeviceOperation op) {
            CompletableFuture opFuture = ((MutableOperation)op).getFuture();
            try {
                op.run(this.pageData);
                opFuture.complete(null);
            }
            catch (Throwable t) {
                opFuture.completeExceptionally(t);
                LOGGER.finest("Exception executing operation " + String.valueOf(op), t);
            }
        }
    }

    private final class DeviceReader
    extends DeviceThread {
        private final byte[] recordPartBuf;

        DeviceReader(String threadName) {
            super(threadName);
            this.recordPartBuf = new byte[DeviceOperationExecutorImpl.this.readPageSize];
        }

        @Override
        DeviceOperation takeOperation() throws InterruptedException {
            return DeviceOperationExecutorImpl.this.readQueue.take();
        }

        @Override
        void executeOp(DeviceOperation op) {
            ImmutableOperation imOp = (ImmutableOperation)op;
            CompletableFuture opFuture = imOp.getFuture();
            try {
                byte[] buf = imOp.getReadLength() > 0 ? new byte[imOp.getReadLength()] : this.recordPartBuf;
                byte[] res = (byte[])imOp.run(buf);
                if (res == this.recordPartBuf) {
                    byte[] copyRes = new byte[res.length];
                    System.arraycopy(res, 0, copyRes, 0, res.length);
                    opFuture.complete(copyRes);
                    return;
                }
                opFuture.complete(res);
            }
            catch (Throwable t) {
                opFuture.completeExceptionally(t);
                LOGGER.finest("Exception executing operation " + String.valueOf(op), t);
            }
        }
    }

    static abstract class DeviceThread
    implements Runnable {
        private final Thread thread;
        private volatile boolean terminated;

        DeviceThread(String threadName) {
            this.thread = new Thread((Runnable)this, threadName);
        }

        void start() {
            this.thread.start();
        }

        abstract DeviceOperation takeOperation() throws InterruptedException;

        abstract void executeOp(DeviceOperation var1);

        @Override
        public void run() {
            try {
                while (!this.terminated && !Thread.currentThread().isInterrupted()) {
                    try {
                        DeviceOperation op = this.takeOperation();
                        this.executeOp(op);
                    }
                    catch (InterruptedException e) {
                        LOGGER.finest(this.getClass().getSimpleName() + " was interrupted");
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
                LOGGER.severe(t);
            }
        }

        void terminate() {
            this.terminated = true;
            this.thread.interrupt();
            this.join();
        }

        private void join() {
            boolean interrupted = false;
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

