/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;

public class RecordPool {
    public static final long FORMAT_SIGNATURE = 8534157919459240307L;
    public static final long FORMAT_VERSION = 0L;
    private static final long NULL = 0L;
    private static final long LATCHED = -1L;
    private static final AtomicLongFieldUpdater<RecordPool> SIZE = AtomicLongFieldUpdater.newUpdater(RecordPool.class, "size");
    private static final AtomicLongFieldUpdater<RecordPool> FREE_LIST = AtomicLongFieldUpdater.newUpdater(RecordPool.class, "freeList");
    private static final AtomicIntegerFieldUpdater<RecordPool> POOL_USER_COUNT = AtomicIntegerFieldUpdater.newUpdater(RecordPool.class, "poolUserCount");
    private final MemoryAllocator allocator;
    private final Mode mode;
    private final int recordSize;
    private final long arrays;
    private volatile long preAllocatedRecords;
    private volatile long size;
    private volatile long freeList = 0L;
    private volatile int poolUserCount;

    public RecordPool(MemoryAllocator allocator, Mode mode, int recordSize, int preAllocatedRecords) {
        assert (QuickMath.isPowerOfTwo(preAllocatedRecords));
        assert (recordSize >= 8);
        this.allocator = allocator;
        this.mode = mode;
        this.recordSize = recordSize;
        this.arrays = allocator.allocate(512L);
        GlobalMemoryAccessorRegistry.AMEM.setMemory(this.arrays, 512L, (byte)0);
        this.preAllocatedRecords = preAllocatedRecords;
        if (this.preAllocatedRecords != 0L) {
            long array = allocator.allocate((long)preAllocatedRecords * (long)recordSize);
            int arrayCount = 32 - Integer.numberOfLeadingZeros(preAllocatedRecords);
            for (int i = 0; i < arrayCount; ++i) {
                RecordPool.write(this.arrays + (long)i * 8L, array);
                long arraySize = (1L << i) + 1L >>> 1;
                array += arraySize * (long)recordSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquire() {
        this.enter();
        try {
            long record;
            while ((record = this.freeList) != 0L) {
                if (record == -1L || !FREE_LIST.compareAndSet(this, record, -1L)) continue;
                long next = RecordPool.read(this.addressOf(record)) ^ 0xFFFFFFFFFFFFFFFFL;
                FREE_LIST.set(this, next);
                long l = record;
                return l;
            }
            long index = SIZE.getAndIncrement(this);
            int arrayIndex = 64 - Long.numberOfLeadingZeros(index);
            long arrayPointer = this.arrays + (long)(arrayIndex * 8);
            long array = RecordPool.read(arrayPointer);
            if (array == 0L) {
                if (RecordPool.cas(arrayPointer, 0L, -1L)) {
                    long arraySize = (1L << arrayIndex) + 1L >>> 1;
                    try {
                        array = this.allocator.allocate(arraySize * (long)this.recordSize);
                    }
                    catch (NativeOutOfMemoryError oom) {
                        RecordPool.write(arrayPointer, 0L);
                        SIZE.decrementAndGet(this);
                        throw oom;
                    }
                    RecordPool.write(arrayPointer, array);
                } else {
                    do {
                        Thread.yield();
                    } while ((array = RecordPool.read(arrayPointer)) == -1L);
                    if (array == 0L) {
                        SIZE.decrementAndGet(this);
                        throw new NativeOutOfMemoryError();
                    }
                }
            } else {
                while (array == -1L) {
                    Thread.yield();
                    array = RecordPool.read(arrayPointer);
                }
                if (array == 0L) {
                    SIZE.decrementAndGet(this);
                    throw new NativeOutOfMemoryError();
                }
            }
            long indexInArray = index - (1L << arrayIndex >>> 1);
            record = array + indexInArray * (long)this.recordSize;
            long l = this.mode.translateToHandle(index, record);
            return l;
        }
        finally {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long record) {
        this.enter();
        long address = this.addressOf(record);
        try {
            long head;
            do {
                head = this.freeList;
                RecordPool.write(address, head ^ 0xFFFFFFFFFFFFFFFFL);
            } while (head == -1L || !FREE_LIST.compareAndSet(this, head, record));
        }
        finally {
            this.exit();
        }
    }

    public long addressOf(long record) {
        return this.mode.translateToAddress(this, record);
    }

    public boolean isAcquired(long record) {
        assert (record != 0L);
        return RecordPool.read(this.addressOf(record)) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(int recordPrefix, LongConsumer writer) {
        block11: {
            this.enter();
            try {
                assert (this.mode == Mode.NUMBERS);
                assert (recordPrefix > 0 && recordPrefix <= this.recordSize);
                assert (recordPrefix % 8 == 0);
                long prefixLongs = recordPrefix / 8;
                writer.accept(8534157919459240307L);
                writer.accept(0L);
                writer.accept(this.size);
                writer.accept(this.freeList);
                for (long i = 0L; i < 64L; ++i) {
                    long array = RecordPool.read(this.arrays + i * 8L);
                    if (array == 0L) {
                        break;
                    }
                    long arraySize = (1L << (int)i) + 1L >>> 1;
                    long record = array;
                    for (long j = 0L; j < arraySize; ++j) {
                        long first = RecordPool.read(record);
                        if (first == 0L) {
                            break block11;
                        }
                        writer.accept(first);
                        for (long k = 1L; k < prefixLongs; ++k) {
                            writer.accept(RecordPool.read(record + k * 8L));
                        }
                        record += (long)this.recordSize;
                    }
                }
            }
            finally {
                this.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(int recordPrefix, LongSupplier reader) {
        this.enter();
        try {
            long array;
            assert (this.mode == Mode.NUMBERS);
            assert (recordPrefix > 0 && recordPrefix <= this.recordSize);
            assert (recordPrefix % 8 == 0);
            long prefixLongs = recordPrefix / 8;
            long signature = reader.getAsLong();
            if (signature != 8534157919459240307L) {
                throw new IllegalArgumentException("unexpected signature " + Long.toHexString(signature));
            }
            long version = reader.getAsLong();
            if (version != 0L) {
                throw new IllegalArgumentException("unexpected version " + version);
            }
            long newSize = reader.getAsLong();
            if (newSize < 0L) {
                throw new IllegalArgumentException("invalid size " + newSize);
            }
            long newFreeList = reader.getAsLong();
            if (newFreeList < 0L) {
                throw new IllegalArgumentException("invalid free list head " + newFreeList);
            }
            if (newSize == 0L) {
                this.size = 0L;
                this.freeList = 0L;
                for (int i = 0; i < 64; ++i) {
                    long array2 = RecordPool.read(this.arrays + (long)(i * 8));
                    if (array2 == 0L) {
                        break;
                    }
                    long arraySize = (1L << i) + 1L >>> 1;
                    GlobalMemoryAccessorRegistry.AMEM.setMemory(array2, arraySize * (long)this.recordSize, (byte)0);
                }
                return;
            }
            long newPreAllocatedRecords = QuickMath.nextPowerOfTwo(newSize);
            long record = array = this.allocator.allocate(newPreAllocatedRecords * (long)this.recordSize);
            for (long i = 0L; i < newSize; ++i) {
                for (long j = 0L; j < prefixLongs; ++j) {
                    long value = reader.getAsLong();
                    RecordPool.write(record + j * 8L, value);
                }
                record += (long)this.recordSize;
            }
            this.releaseArrays();
            GlobalMemoryAccessorRegistry.AMEM.setMemory(this.arrays, 512L, (byte)0);
            this.preAllocatedRecords = newPreAllocatedRecords;
            this.size = newSize;
            this.freeList = newFreeList;
            int arrayCount = 64 - Long.numberOfLeadingZeros(newPreAllocatedRecords);
            for (int i = 0; i < arrayCount; ++i) {
                RecordPool.write(this.arrays + (long)i * 8L, array);
                long arraySize = (1L << i) + 1L >>> 1;
                array += arraySize * (long)this.recordSize;
            }
        }
        finally {
            this.exit();
        }
    }

    public long recordOf(long address) {
        if (this.mode == Mode.POINTERS) {
            return address;
        }
        assert (this.mode == Mode.NUMBERS);
        for (long i = 0L; i < 64L; ++i) {
            long array = RecordPool.read(this.arrays + i * 8L);
            if (array == 0L) {
                return 0L;
            }
            long arraySize = 1L << (int)i;
            long arrayEnd = array + arraySize * (long)this.recordSize;
            if (address < array || address >= arrayEnd) continue;
            long indexInArray = (address - array) / (long)this.recordSize;
            long baseIndex = arraySize >>> 1;
            return baseIndex + indexInArray + 1L;
        }
        return 0L;
    }

    public void close() {
        this.closeEnter();
        try {
            this.releaseArrays();
            this.allocator.free(this.arrays, 512L);
        }
        finally {
            this.closeExit();
        }
    }

    private void releaseArrays() {
        int preAllocatedArrayCount;
        long array;
        if (this.preAllocatedRecords != 0L) {
            this.allocator.free(RecordPool.read(this.arrays), this.preAllocatedRecords * (long)this.recordSize);
        }
        for (int i = preAllocatedArrayCount = 64 - Long.numberOfLeadingZeros(this.preAllocatedRecords); i < 64 && (array = RecordPool.read(this.arrays + (long)(i * 8))) != 0L; ++i) {
            long arraySize = (1L << i) + 1L >>> 1;
            this.allocator.free(array, arraySize * (long)this.recordSize);
        }
    }

    private void enter() {
        int userCnt;
        while ((userCnt = POOL_USER_COUNT.get(this)) != -1 && !POOL_USER_COUNT.weakCompareAndSet(this, userCnt, userCnt + 1)) {
        }
        if (userCnt == -1) {
            throw new IllegalStateException("record pool has been closed");
        }
    }

    private void exit() {
        int userCnt = POOL_USER_COUNT.getAndDecrement(this);
        Invariants.greaterOrEqualThan(userCnt, 0, "Pool had been closed before all threads finished read/write on it.");
    }

    private void closeEnter() {
        while (!POOL_USER_COUNT.weakCompareAndSet(this, 0, -1)) {
            Thread.yield();
            if (POOL_USER_COUNT.get(this) != -1) continue;
            throw new IllegalStateException("record pool has been closed");
        }
    }

    private void closeExit() {
    }

    long getSize() {
        return this.size;
    }

    private static long read(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static void write(long address, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, value);
    }

    private static boolean cas(long address, long expected, long value) {
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(address, expected, value);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        POINTERS{

            @Override
            long translateToHandle(long index, long address) {
                return address;
            }

            @Override
            long translateToAddress(RecordPool pool, long handle) {
                return handle;
            }
        }
        ,
        NUMBERS{

            @Override
            long translateToHandle(long index, long address) {
                return index + 1L;
            }

            @Override
            long translateToAddress(RecordPool pool, long handle) {
                long index = handle - 1L;
                int arrayIndex = 64 - Long.numberOfLeadingZeros(index);
                long indexInArray = index - (1L << arrayIndex >>> 1);
                long arrayPointer = pool.arrays + (long)(arrayIndex * 8);
                long array = RecordPool.read(arrayPointer);
                return array + indexInArray * (long)pool.recordSize;
            }
        };


        abstract long translateToHandle(long var1, long var3);

        abstract long translateToAddress(RecordPool var1, long var2);
    }
}

