/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

public final class Preconditions {
    private Preconditions() {
    }

    public static <E> E checkInstanceOf(Class<E> type, Object object, String paramName) {
        Preconditions.checkNotNull(type, "type");
        Preconditions.checkNotNull(object, paramName);
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException("object " + String.valueOf(object) + " of type " + String.valueOf(object.getClass()) + " is not an instanceof " + String.valueOf(type));
        }
        return (E)object;
    }

    public static int checkPositive(int value, String paramName) {
        if (value <= 0) {
            throw new IllegalArgumentException(paramName + " is " + value + " but must be > 0");
        }
        return value;
    }

    public static int checkNotNegative(int value, String paramName) {
        if (value < 0) {
            throw new IllegalArgumentException(paramName + " is " + value + " but must be >= 0");
        }
        return value;
    }

    public static long checkNotNegative(long value, String paramName) {
        if (value < 0L) {
            throw new IllegalArgumentException(paramName + " is " + value + " but must be >= 0");
        }
        return value;
    }

    public static <T> T checkNotNull(T argument, String name) {
        if (argument == null) {
            throw new NullPointerException(name + " can't be null");
        }
        return argument;
    }

    public static <T> T checkNotNull(T argument) {
        if (argument == null) {
            throw new NullPointerException();
        }
        return argument;
    }
}

