/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.cluster.impl.MemberHandshake;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SendMemberHandshakeTask
implements Runnable {
    private final ILogger logger;
    private final ServerContext serverContext;
    private final TcpServerConnection connection;
    private final Address remoteAddress;
    private final boolean reply;
    private final int planeIndex;
    private final int planeCount;

    public SendMemberHandshakeTask(ILogger logger, ServerContext serverContext, TcpServerConnection connection, Address remoteAddress, boolean reply, int planeIndex, int planeCount) {
        this.logger = logger;
        this.serverContext = serverContext;
        this.connection = connection;
        this.remoteAddress = remoteAddress;
        this.reply = reply;
        this.planeIndex = planeIndex;
        this.planeCount = planeCount;
    }

    @Override
    public void run() {
        this.connection.setRemoteAddress(this.remoteAddress);
        this.serverContext.onSuccessfulConnection(this.remoteAddress);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending memberHandshake packet to " + String.valueOf(this.remoteAddress));
        }
        MemberHandshake memberHandshake = new MemberHandshake(2, this.getConfiguredLocalAddresses(), this.remoteAddress, this.reply, this.serverContext.getThisUuid()).addOption("planeCount", this.planeCount).addOption("planeIndex", this.planeIndex);
        byte[] bytes = this.serverContext.getSerializationService().toBytes(memberHandshake);
        Packet packet = new Packet(bytes).setPacketType(Packet.Type.SERVER_CONTROL);
        this.connection.write(packet);
    }

    Map<ProtocolType, Collection<Address>> getConfiguredLocalAddresses() {
        EndpointQualifier qualifier = this.connection.getConnectionManager().getEndpointQualifier();
        boolean isWanHandshake = qualifier != null && qualifier.getType().equals((Object)ProtocolType.WAN);
        HashMap<ProtocolType, Collection<Address>> addressMap = new HashMap<ProtocolType, Collection<Address>>();
        this.populateAddressMap(addressMap, isWanHandshake);
        if (addressMap.isEmpty() && isWanHandshake) {
            this.populateAddressMap(addressMap, false);
        }
        return addressMap;
    }

    private void populateAddressMap(Map<ProtocolType, Collection<Address>> addressMap, boolean isWanHandshake) {
        Map<EndpointQualifier, Address> addressesPerEndpointQualifier = this.serverContext.getThisAddresses();
        for (Map.Entry<EndpointQualifier, Address> addressEntry : addressesPerEndpointQualifier.entrySet()) {
            if (isWanHandshake && !addressEntry.getKey().getType().equals((Object)ProtocolType.WAN)) continue;
            Collection addresses = addressMap.computeIfAbsent(addressEntry.getKey().getType(), k -> new ArrayList());
            addresses.add(addressEntry.getValue());
        }
    }
}

