/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataInput;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataOutput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.InputOutputFactory;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.EnterpriseUnsafeObjectDataInput;
import com.hazelcast.internal.serialization.impl.EnterpriseUnsafeObjectDataOutput;
import com.hazelcast.internal.serialization.impl.MemoryBlockDataInput;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.nio.ByteOrder;

final class EnterpriseUnsafeInputOutputFactory
implements InputOutputFactory {
    EnterpriseUnsafeInputOutputFactory() {
    }

    @Override
    public EnterpriseBufferObjectDataInput createInput(Data data, InternalSerializationService service, boolean isCompatibility) {
        EnterpriseSerializationService serializationService = (EnterpriseSerializationService)service;
        if (data instanceof NativeMemoryData) {
            NativeMemoryData memoryBlock = (NativeMemoryData)data;
            return new MemoryBlockDataInput(memoryBlock, 8, 4, serializationService);
        }
        return new EnterpriseUnsafeObjectDataInput(data.toByteArray(), 8, serializationService, isCompatibility);
    }

    @Override
    public EnterpriseBufferObjectDataInput createInput(byte[] buffer, InternalSerializationService service, boolean isCompatibility) {
        return new EnterpriseUnsafeObjectDataInput(buffer, 0, (EnterpriseSerializationService)service, isCompatibility);
    }

    @Override
    public EnterpriseBufferObjectDataInput createInput(byte[] buffer, int offset, InternalSerializationService service, boolean isCompatibility) {
        return new EnterpriseUnsafeObjectDataInput(buffer, offset, (EnterpriseSerializationService)service, isCompatibility);
    }

    @Override
    public EnterpriseBufferObjectDataOutput createOutput(int size, InternalSerializationService service) {
        return new EnterpriseUnsafeObjectDataOutput(size, (EnterpriseSerializationService)service);
    }

    @Override
    public BufferObjectDataOutput createOutput(int initialSize, int firstGrowthSize, InternalSerializationService service) {
        return new EnterpriseUnsafeObjectDataOutput(initialSize, firstGrowthSize, (EnterpriseSerializationService)service);
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.nativeOrder();
    }
}

