/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.GarbageCollectable;
import com.hazelcast.internal.memory.GarbageCollector;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class SimpleGarbageCollector
extends Thread
implements GarbageCollector {
    private static final int JOIN_MILLIS = 10000;
    private final Set<GarbageCollectable> garbageCollectables = Collections.newSetFromMap(new ConcurrentHashMap());

    SimpleGarbageCollector(String name) {
        super(name);
        this.setDaemon(true);
    }

    @Override
    public boolean registerGarbageCollectable(GarbageCollectable participant) {
        return this.garbageCollectables.add(participant);
    }

    @Override
    public boolean deregisterGarbageCollectable(GarbageCollectable participant) {
        return this.garbageCollectables.remove(participant);
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.garbageCollectables.clear();
                    return;
                }
                this.gc();
            }
        }
        finally {
            this.garbageCollectables.clear();
        }
    }

    private void gc() {
        for (GarbageCollectable garbageCollectable : this.garbageCollectables) {
            if (this.isInterrupted()) {
                return;
            }
            try {
                garbageCollectable.gc();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void abort() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join(10000L);
            }
            catch (InterruptedException e) {
                this.interrupt();
                e.printStackTrace();
            }
        }
    }
}

