/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.io;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileCursor;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileRecord;
import com.hazelcast.internal.nio.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class ChunkFilesetCursor {
    private static final int HEX_RADIX = 16;
    final EncryptionManager encryptionMgr;
    private ChunkFileCursor currentChunkCursor;
    private final List<File> chunkFiles;

    ChunkFilesetCursor(List<File> chunkFiles, EncryptionManager encryptionMgr) {
        this.chunkFiles = chunkFiles;
        this.encryptionMgr = encryptionMgr;
    }

    public static long seq(File f) {
        return Long.parseLong(f.getName().substring(0, 16), 16);
    }

    public static boolean isActiveChunkFile(File f) {
        return f.getName().endsWith(".chunk.active");
    }

    public final boolean advance() throws InterruptedException {
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.currentChunkCursor == null && !this.tryOpenNextChunk()) {
                this.chunkFiles.clear();
                return false;
            }
            if (this.currentChunkCursor.advance()) {
                return true;
            }
            this.currentChunkCursor.close();
            this.currentChunkCursor = null;
        }
    }

    public final ChunkFileRecord currentRecord() {
        return this.currentChunkCursor;
    }

    public final void close() {
        if (this.currentChunkCursor != null) {
            this.currentChunkCursor.close();
            this.currentChunkCursor = null;
        }
        this.chunkFiles.clear();
    }

    abstract ChunkFileCursor openCursor(File var1) throws IOException;

    private boolean tryOpenNextChunk() {
        try {
            File chunkFile = this.findNonemptyFile();
            if (chunkFile == null) {
                return false;
            }
            this.currentChunkCursor = this.openCursor(chunkFile);
            return true;
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    private File findNonemptyFile() {
        while (!this.chunkFiles.isEmpty()) {
            File f = this.chunkFiles.remove(this.chunkFiles.size() - 1);
            if (!this.isEmptyChunk(f)) {
                return f;
            }
            IOUtil.delete(f);
        }
        return null;
    }

    private boolean isEmptyChunk(File chunkFile) {
        return this.encryptionMgr.isEffectivelyEmpty(chunkFile);
    }

    static void removeActiveSuffix(File activeChunkFile) {
        String nameNow = activeChunkFile.getName();
        String nameToBe = nameNow.substring(0, nameNow.length() - ".active".length());
        IOUtil.rename(activeChunkFile, new File(activeChunkFile.getParent(), nameToBe));
    }

    public static class Tomb
    extends ChunkFilesetCursor {
        public Tomb(List<File> chunkFiles, EncryptionManager encryptionMgr) {
            super(chunkFiles, encryptionMgr);
        }

        @Override
        ChunkFileCursor openCursor(File chunkFile) {
            return new ChunkFileCursor.Tomb(chunkFile, this.encryptionMgr);
        }
    }

    public static class Val
    extends ChunkFilesetCursor {
        public Val(List<File> chunkFiles, EncryptionManager encryptionMgr) {
            super(chunkFiles, encryptionMgr);
        }

        @Override
        ChunkFileCursor openCursor(File chunkFile) {
            return new ChunkFileCursor.Val(chunkFile, this.encryptionMgr);
        }
    }
}

