/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.hotrestart.impl.RamStoreRestartLoop;
import com.hazelcast.internal.hotrestart.impl.RestartItem;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.PrefixTombstoneManager;
import com.hazelcast.internal.hotrestart.impl.gc.Rebuilder;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileRecord;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFilesetCursor;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.BufferingInputStream;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.collection.Long2LongHashMap;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorException;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorSingleQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class HotRestarter {
    public static final int LOG_OF_BUFFER_SIZE = 16;
    public static final int BUFFER_SIZE = 65536;
    private static final int REBUILDER_JOIN_TIMEOUT_IN_MILLIS = 5000;
    private static final int PREFIX_TOMBSTONE_ENTRY_SIZE = 16;
    private static final Comparator<File> BY_SEQ = Comparator.comparingLong(ChunkFilesetCursor::seq);
    private static final Pattern RX_BUCKET_DIR = Pattern.compile(String.format("[0-9a-f]{%d}", 2));
    private static final FileFilter BUCKET_DIRS_ONLY = f -> f.isDirectory() && RX_BUCKET_DIR.matcher(f.getName()).matches();
    private static final FileFilter CHUNK_FILES_ONLY = f -> f.isFile() && (f.getName().endsWith(".chunk") || ChunkFilesetCursor.isActiveChunkFile(f));
    private static final int RECORD_COUNT_NULL_SENTINEL = -2;
    volatile long recordCountInCurrentPhase = -2L;
    volatile Throwable rebuilderFailure;
    private final PrefixTombstoneManager pfixTombstoMgr;
    private final GcHelper gcHelper;
    private final File homeDir;
    private final String storeName;
    private final Integer storeCount;
    private final ConcurrentConveyorSingleQueue<RestartItem>[] keySenders;
    private final ConcurrentConveyor<RestartItem> keyHandleReceiver;
    private final ConcurrentConveyorSingleQueue<RestartItem>[] valueSenders;
    private final GcLogger logger;
    private final RamStoreRegistry reg;
    private final EncryptionManager encryptionMgr;
    private Rebuilder rebuilder;
    private Long2LongHashMap prefixTombstones;

    @Inject
    HotRestarter(Rebuilder rebuilder, PrefixTombstoneManager pfixTombstoMgr, GcHelper gcHelper, RamStoreRegistry reg, GcLogger logger, EncryptionManager encryptionMgr, @Name(value="homeDir") File homeDir, @Name(value="storeName") String storeName, @Name(value="storeCount") Integer storeCount, @Name(value="keyConveyors") ConcurrentConveyorSingleQueue<RestartItem>[] keySenders, @Name(value="keyHandleConveyor") ConcurrentConveyor<RestartItem> keyHandleReceiver, @Name(value="valueConveyors") ConcurrentConveyorSingleQueue<RestartItem>[] valueSenders) {
        this.rebuilder = rebuilder;
        this.pfixTombstoMgr = pfixTombstoMgr;
        this.gcHelper = gcHelper;
        this.reg = reg;
        this.logger = logger;
        this.encryptionMgr = encryptionMgr;
        this.homeDir = homeDir;
        this.storeName = storeName;
        this.storeCount = storeCount;
        this.keySenders = keySenders;
        this.keyHandleReceiver = keyHandleReceiver;
        this.valueSenders = valueSenders;
    }

    public void restart(boolean failIfAnyData) throws InterruptedException {
        Thread rebuilderThread = new Thread((Runnable)new RebuilderLoop(), this.storeName + ".rebuilder");
        Throwable localFailure = null;
        try {
            Long2LongHashMap prefixTombstones = HotRestarter.restorePrefixTombstones(this.homeDir);
            this.logger.finestVerbose("Reloaded prefix tombstones %s", prefixTombstones);
            this.pfixTombstoMgr.setPrefixTombstones(prefixTombstones);
            this.prefixTombstones = prefixTombstones;
            this.rebuilder.setMaxSeq(this.pfixTombstoMgr.maxRecordSeq());
            ChunkFilesetCursor.Tomb tombCursor = new ChunkFilesetCursor.Tomb(this.sortedChunkFiles("tombstone"), this.encryptionMgr);
            ChunkFilesetCursor.Val valCursor = new ChunkFilesetCursor.Val(this.sortedChunkFiles("value"), this.encryptionMgr);
            if (failIfAnyData && (tombCursor.advance() || valCursor.advance())) {
                throw new HotRestartException("failIfAnyData == true and there's data to reload");
            }
            rebuilderThread.start();
            this.readRecords(tombCursor);
            this.readRecords(valCursor);
        }
        catch (Throwable t) {
            localFailure = t;
        }
        localFailure = HotRestarter.firstNonNull(localFailure, HotRestarter.sendSubmitterGone(this.keySenders));
        try {
            do {
                rebuilderThread.join(5000L);
                this.propagateLocalAndRebuilderFailure(localFailure);
                this.logger.fine("Waiting to join the Rebuilder thread");
            } while (rebuilderThread.isAlive());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static Long2LongHashMap restorePrefixTombstones(File homeDir) {
        File f = new File(homeDir, "prefix-tombstones");
        if (!f.exists()) {
            return new Long2LongHashMap(0L);
        }
        if (!f.isFile() || !f.canRead()) {
            throw new HotRestartException("Not a regular, readable file: " + f.getAbsolutePath());
        }
        Long2LongHashMap prefixTombstones = new Long2LongHashMap((int)(f.length() / 16L), 0.6, 0L);
        BufferingInputStream in = null;
        try {
            in = new BufferingInputStream(new FileInputStream(f), 65536);
            byte[] entryBuf = new byte[16];
            ByteBuffer byteBuf = ByteBuffer.wrap(entryBuf);
            while (IOUtil.readFullyOrNothing(in, entryBuf)) {
                prefixTombstones.put(byteBuf.getLong(0), byteBuf.getLong(8));
            }
        }
        catch (IOException e) {
            try {
                throw new HotRestartException("Error restoring prefix tombstones", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(in);
                throw throwable;
            }
        }
        IOUtil.closeResource(in);
        return prefixTombstones;
    }

    private List<File> sortedChunkFiles(String base) {
        ArrayList<File> files = new ArrayList<File>(128);
        File[] bucketDirs = new File(this.homeDir, base).listFiles(BUCKET_DIRS_ONLY);
        if (bucketDirs == null) {
            return files;
        }
        for (File d : bucketDirs) {
            File[] chunksInBucket = d.listFiles(CHUNK_FILES_ONLY);
            if (chunksInBucket == null) {
                throw new HotRestartException("Failed to list directory contents: " + String.valueOf(d));
            }
            if (chunksInBucket.length == 0) continue;
            Collections.addAll(files, chunksInBucket);
        }
        files.sort(BY_SEQ);
        return files;
    }

    private void readRecords(ChunkFilesetCursor cursor) throws InterruptedException {
        long count = 0L;
        while (cursor.advance()) {
            ++count;
            ChunkFileRecord rec = cursor.currentRecord();
            long prefix = rec.prefix();
            try {
                this.keySenders[this.reg.prefixToThreadId(prefix) / this.storeCount].submit(rec.recordSeq() > this.prefixTombstones.get(prefix) ? new RestartItem(rec) : RestartItem.clearedItem(rec));
            }
            catch (ConcurrentConveyorException e) {
                this.logger.severe("Failed to submit to threadIndex " + this.reg.prefixToThreadId(prefix));
                cursor.close();
                throw e;
            }
        }
        this.awaitDownstreamCompletion(count);
    }

    private void awaitDownstreamCompletion(long count) {
        this.recordCountInCurrentPhase = count;
        long i = 0L;
        while (this.recordCountInCurrentPhase != -1L) {
            ConcurrentConveyor.SUBMIT_IDLER.idle(i);
            this.propagateLocalAndRebuilderFailure(null);
            ++i;
        }
    }

    private void propagateLocalAndRebuilderFailure(Throwable localFailure) {
        Throwable rebuilderFailure = this.rebuilderFailure;
        if (localFailure != null) {
            if (rebuilderFailure != null && !(localFailure instanceof RebuilderFailure)) {
                this.logger.severe("Both HotRestarter and Rebuilder loops failed. Reporting Rebuilder failure:", rebuilderFailure);
            }
            ExceptionUtil.sneakyThrow(localFailure);
        }
        if (rebuilderFailure != null) {
            throw new RebuilderFailure(rebuilderFailure);
        }
    }

    static ConcurrentConveyorException sendSubmitterGone(ConcurrentConveyorSingleQueue<RestartItem> ... conveyors) {
        RestartItem goneItem = (RestartItem)conveyors[0].submitterGoneItem();
        for (ConcurrentConveyorSingleQueue<RestartItem> valueConveyor : conveyors) {
            try {
                valueConveyor.submit(goneItem);
            }
            catch (ConcurrentConveyorException e) {
                return e;
            }
        }
        return null;
    }

    private static <T> T firstNonNull(T t1, T t2) {
        return t1 != null ? t1 : t2;
    }

    private class RebuilderLoop
    implements Runnable {
        private final int submitterCount;
        private final List<RestartItem> batch;
        private final Map<Long, SetOfKeyHandle> tombKeys;
        private final RestartItem submitterGoneItem;
        private int submitterGoneCount;

        private RebuilderLoop() {
            this.submitterCount = HotRestarter.this.keyHandleReceiver.queueCount();
            this.batch = new ArrayList<RestartItem>(HotRestarter.this.keyHandleReceiver.queue(0).capacity());
            this.tombKeys = new Long2ObjectHashMap<SetOfKeyHandle>();
            this.submitterGoneItem = HotRestarter.this.keyHandleReceiver.submitterGoneItem();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HotRestarter.this.keyHandleReceiver.drainerArrived();
                this.drainTombstones();
                HotRestarter.this.recordCountInCurrentPhase = -1L;
                HotRestarter.this.rebuilder.startValuePhase(this.tombKeys);
                this.conveyValues();
                HotRestarter.this.recordCountInCurrentPhase = -1L;
                for (Map.Entry<Long, SetOfKeyHandle> entry : this.tombKeys.entrySet()) {
                    HotRestarter.this.valueSenders[HotRestarter.this.reg.prefixToThreadId(entry.getKey()) / HotRestarter.this.storeCount].submit(new RestartItem.WithSetOfKeyHandle(entry.getKey(), entry.getValue()));
                }
                HotRestarter.this.gcHelper.initChunkSeq(HotRestarter.this.rebuilder.maxChunkSeq());
                HotRestarter.this.rebuilder.done();
            }
            catch (Throwable t) {
                HotRestarter.this.rebuilderFailure = t;
            }
            finally {
                block17: {
                    try {
                        HotRestarter.sendSubmitterGone(HotRestarter.this.valueSenders);
                        for (ConcurrentConveyorSingleQueue<RestartItem> valueSender : HotRestarter.this.valueSenders) {
                            valueSender.awaitDrainerGone();
                        }
                        for (Map.Entry entry : this.tombKeys.entrySet()) {
                            ((SetOfKeyHandle)entry.getValue()).dispose();
                        }
                    }
                    catch (Throwable t) {
                        if (HotRestarter.this.rebuilderFailure != null) break block17;
                        HotRestarter.this.rebuilderFailure = t;
                    }
                }
            }
            if (HotRestarter.this.rebuilderFailure == null) {
                HotRestarter.this.keyHandleReceiver.drainerDone();
            } else {
                HotRestarter.this.keyHandleReceiver.drainerFailed(HotRestarter.this.rebuilderFailure);
            }
        }

        private void drainTombstones() {
            long idleCount = 0L;
            long itemsDrained = 0L;
            while (itemsDrained != HotRestarter.this.recordCountInCurrentPhase) {
                this.checkSubmittersGone();
                for (int i = 0; i < HotRestarter.this.keyHandleReceiver.queueCount(); ++i) {
                    this.batch.clear();
                    int count = HotRestarter.this.keyHandleReceiver.drainTo(i, this.batch);
                    if (count > 0) {
                        this.processTombstoneDrain();
                        itemsDrained += (long)count;
                        idleCount = 0L;
                        continue;
                    }
                    RamStoreRestartLoop.DRAIN_IDLER.idle(idleCount++);
                }
            }
        }

        private void conveyValues() {
            long drainOpCount = 0L;
            long idleCount = 0L;
            long itemsDrained = 0L;
            while (HotRestarter.this.recordCountInCurrentPhase != itemsDrained) {
                this.checkSubmittersGone();
                for (int i = 0; i < HotRestarter.this.keyHandleReceiver.queueCount(); ++i) {
                    this.batch.clear();
                    int count = HotRestarter.this.keyHandleReceiver.drainTo(i, this.batch);
                    if (count > 0) {
                        this.processValueDrain(HotRestarter.this.valueSenders[i]);
                        idleCount = 0L;
                        itemsDrained += (long)count;
                        ++drainOpCount;
                        continue;
                    }
                    RamStoreRestartLoop.DRAIN_IDLER.idle(idleCount++);
                }
            }
            int capacity = HotRestarter.this.keyHandleReceiver.queue(0).capacity();
            HotRestarter.this.logger.finest("%s.conveyValues: drained %,d items, mean queue size was %.1f (capacity %,d)", HotRestarter.this.storeName, HotRestarter.this.recordCountInCurrentPhase, (double)HotRestarter.this.recordCountInCurrentPhase / (double)drainOpCount, capacity);
        }

        private void processTombstoneDrain() {
            for (RestartItem item : this.batch) {
                if (!item.isSpecialItem()) {
                    this.addTombKey(item.keyHandle, item.prefix);
                    HotRestarter.this.rebuilder.preAccept(item.recordSeq, item.size);
                    HotRestarter.this.rebuilder.accept(item);
                    continue;
                }
                this.processSpecialItem(item);
            }
        }

        private void processValueDrain(ConcurrentConveyorSingleQueue<RestartItem> outConveyor) {
            for (RestartItem item : this.batch) {
                if (!item.isSpecialItem()) {
                    HotRestarter.this.rebuilder.preAccept(item.recordSeq, item.size);
                    if (!HotRestarter.this.rebuilder.accept(item)) continue;
                    outConveyor.submit(item);
                    continue;
                }
                this.processSpecialItem(item);
            }
        }

        private void processSpecialItem(RestartItem item) {
            if (item.isClearedItem()) {
                HotRestarter.this.rebuilder.preAccept(item.recordSeq, item.size);
                HotRestarter.this.rebuilder.acceptCleared(item);
            } else {
                assert (item == this.submitterGoneItem);
                ++this.submitterGoneCount;
            }
        }

        private void addTombKey(KeyHandle kh, long prefix) {
            SetOfKeyHandle sokh = this.tombKeys.get(prefix);
            if (sokh == null) {
                sokh = HotRestarter.this.gcHelper.newSetOfKeyHandle();
                this.tombKeys.put(prefix, sokh);
            }
            sokh.add(kh);
        }

        private void checkSubmittersGone() {
            if (this.submitterGoneCount == this.submitterCount) {
                throw new HotRestartException(String.format("All submitters left prematurely (there were %d)", this.submitterCount));
            }
        }
    }

    private static class RebuilderFailure
    extends RuntimeException {
        RebuilderFailure(Throwable cause) {
            super(cause);
        }
    }
}

