/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterSerializerHook;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterStartStatus;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class SendClusterStartResultOperation
extends Operation
implements JoinOperation {
    private HotRestartClusterStartStatus result;
    private Set<UUID> excludedMemberUuids;
    private ClusterState clusterState;

    public SendClusterStartResultOperation() {
    }

    public SendClusterStartResultOperation(HotRestartClusterStartStatus result, Set<UUID> excludedMemberUuids, ClusterState clusterState) {
        this.result = result;
        this.excludedMemberUuids = excludedMemberUuids == null ? Collections.emptySet() : excludedMemberUuids;
        this.clusterState = clusterState;
    }

    public static SendClusterStartResultOperation newFailureResultOperation() {
        return new SendClusterStartResultOperation(HotRestartClusterStartStatus.CLUSTER_START_FAILED, null, null);
    }

    @Override
    public void run() throws Exception {
        Address caller = this.getCallerAddress();
        HotRestartIntegrationService service = (HotRestartIntegrationService)this.getService();
        ClusterMetadataManager clusterMetadataManager = service.getClusterMetadataManager();
        clusterMetadataManager.receiveHotRestartStatus(caller, this.result, this.excludedMemberUuids, this.clusterState);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:ee:internalHotRestartService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.result.name());
        out.writeInt(this.excludedMemberUuids.size());
        for (UUID uuid : this.excludedMemberUuids) {
            UUIDSerializationUtil.writeUUID(out, uuid);
        }
        boolean clusterStateExists = this.clusterState != null;
        out.writeBoolean(clusterStateExists);
        if (clusterStateExists) {
            out.writeString(this.clusterState.name());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.result = HotRestartClusterStartStatus.valueOf(in.readString());
        int uuidCount = in.readInt();
        this.excludedMemberUuids = new HashSet<UUID>();
        for (int i = 0; i < uuidCount; ++i) {
            this.excludedMemberUuids.add(UUIDSerializationUtil.readUUID(in));
        }
        boolean clusterStateExists = in.readBoolean();
        if (clusterStateExists) {
            this.clusterState = ClusterState.valueOf(in.readString());
        }
    }

    @Override
    public int getFactoryId() {
        return HotRestartClusterSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

