/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.tree.impl;

import com.hazelcast.internal.elastic.tree.impl.RedBlackTreeNode;
import com.hazelcast.internal.memory.MemoryBlock;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EntryValuesIterator
implements Iterator<MemoryBlock> {
    private RedBlackTreeNode.EntryValueNode next;

    EntryValuesIterator(RedBlackTreeNode.Entry entry) {
        this.next = entry.getValuesHead();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MemoryBlock next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element for iteration");
        }
        try {
            MemoryBlock memoryBlock = this.next.value();
            return memoryBlock;
        }
        finally {
            this.next = this.next.next();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

