/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic;

import com.hazelcast.internal.memory.MemoryAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryManager;
import com.hazelcast.internal.nio.Disposable;

public final class LongArray
implements Disposable {
    private final MemoryAllocator malloc;
    private final MemoryAccessor mem;
    private long baseAddress;
    private long length;

    public LongArray(MemoryManager memMgr, long length) {
        this.malloc = memMgr.getAllocator();
        this.mem = memMgr.getAccessor();
        this.length = length;
        this.baseAddress = length > 0L ? this.malloc.allocate(LongArray.lengthInBytes(length)) : 0L;
    }

    public long get(long index) {
        return this.mem.getLong(this.addressOfElement(index));
    }

    public void set(long index, long value) {
        this.mem.putLong(this.addressOfElement(index), value);
    }

    public void expand(long newLength) {
        if (newLength == this.length) {
            return;
        }
        assert (newLength > this.length) : String.format("Requested to expand to smaller length. Current %,d, requested %,d", this.length, newLength);
        long currentSize = LongArray.lengthInBytes(this.length);
        long newSize = LongArray.lengthInBytes(newLength);
        this.baseAddress = this.malloc.reallocate(this.baseAddress, currentSize, newSize);
        this.length = newLength;
    }

    public long address() {
        return this.baseAddress;
    }

    public long length() {
        return this.length;
    }

    @Override
    public void dispose() {
        if (this.baseAddress != 0L) {
            this.malloc.free(this.baseAddress, LongArray.lengthInBytes(this.length));
            this.baseAddress = 0L;
            this.length = 0L;
        }
    }

    private long addressOfElement(long index) {
        assert (this.baseAddress != 0L);
        assert (index >= 0L && index < this.length) : "Native array index out of bounds: " + index + " vs. length " + this.length;
        return this.baseAddress + LongArray.lengthInBytes(index);
    }

    private static long lengthInBytes(long lengthInElements) {
        return lengthInElements * 8L;
    }
}

