/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.service.impl.operation;

import com.hazelcast.config.Config;
import com.hazelcast.internal.config.service.impl.serialization.EnterpriseConfigDataSerializerHook;
import com.hazelcast.internal.config.util.ConfigDataMaskingUtil;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GetConfigurationFileOperation
extends Operation
implements IdentifiedDataSerializable {
    private String response;

    @Override
    public void run() throws Exception {
        Config config = this.getNodeEngine().getConfig();
        File configurationFile = config.getConfigurationFile();
        if (configurationFile != null) {
            this.response = ConfigDataMaskingUtil.maskSensitiveData(Files.readString(configurationFile.toPath()));
        } else {
            URL configurationUrl = config.getConfigurationUrl();
            if (configurationUrl != null) {
                URI uri = configurationUrl.toURI();
                Path path = Paths.get(uri);
                String configString = Files.readString(path);
                this.response = ConfigDataMaskingUtil.maskSensitiveData(configString);
            }
        }
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public int getFactoryId() {
        return EnterpriseConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }
}

