/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.service.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.config.service.ConfigFileService;
import com.hazelcast.internal.config.service.impl.operation.GetConfigurationFileOperation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public class EnterpriseConfigFileService
implements ConfigFileService {
    private final OperationService operationService;
    private final ClusterService clusterService;
    private final Executor executor;

    public EnterpriseConfigFileService(OperationService operationService, ClusterService clusterService, ExecutionService executionService) {
        this.operationService = operationService;
        this.clusterService = clusterService;
        this.executor = executionService.getExecutor("hz:async");
    }

    @Override
    public Future<Map<UUID, String>> getConfigurationForAllMembers() {
        Set<Member> members = this.clusterService.getMembers();
        HashMap futures = new HashMap();
        members.forEach(m -> futures.put(m.getUuid(), this.operationService.invokeOnTarget("hz:configurationFileService", new GetConfigurationFileOperation(), m.getAddress())));
        return CompletableFuture.allOf((CompletableFuture[])futures.values().toArray(CompletableFuture[]::new)).handleAsync((r, t) -> {
            if (t != null) {
                throw new HazelcastException("Failed to get configurations.", (Throwable)t);
            }
            HashMap configs = new HashMap();
            futures.forEach((u, f) -> {
                try {
                    String memberConfig = (String)f.get();
                    configs.put(u, memberConfig == null ? "" : memberConfig);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new HazelcastException(e);
                }
            });
            return configs;
        }, this.executor);
    }

    @Override
    public Future<String> getConfiguration(UUID memberId) {
        MemberImpl member = this.clusterService.getMember(memberId);
        if (member == null) {
            throw new TargetNotMemberException("No member with UUID " + String.valueOf(memberId) + " exists in cluster.");
        }
        return this.operationService.invokeOnTarget("hz:configurationFileService", new GetConfigurationFileOperation(), member.getAddress());
    }
}

