/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterJoinManager;
import com.hazelcast.internal.cluster.impl.operations.OnJoinOp;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;

public class ClusterJoinManagerSyncJoinStrategy {
    long timeToStartJoin;
    private final ClusterJoinManager clusterJoinManager;
    private final ILogger logger;
    private final long maxWaitMillisBeforeJoin;
    private final long waitMillisBeforeJoin;
    private long firstJoinRequest;

    ClusterJoinManagerSyncJoinStrategy(ClusterJoinManager clusterJoinManager, ILogger logger, long maxWaitMillisBeforeJoin, long waitMillisBeforeJoin) {
        this.clusterJoinManager = clusterJoinManager;
        this.logger = logger;
        this.maxWaitMillisBeforeJoin = maxWaitMillisBeforeJoin;
        this.waitMillisBeforeJoin = waitMillisBeforeJoin;
    }

    void startJoinRequest(MemberInfo memberInfo, OnJoinOp preJoinOperation) {
        BiTuple<MemberInfo, OnJoinOp> existing;
        long now = Clock.currentTimeMillis();
        if (this.logger.isFineEnabled()) {
            String timeToStart = this.timeToStartJoin > 0L ? ", timeToStart: " + (this.timeToStartJoin - now) : "";
            this.logger.fine(String.format("Handling join from %s, joinInProgress: %b%s", memberInfo.getAddress(), this.clusterJoinManager.isJoinInProgress(), timeToStart));
        }
        if (this.firstJoinRequest == 0L) {
            this.firstJoinRequest = now;
        }
        if ((existing = this.clusterJoinManager.joiningMembers.put(memberInfo.getAddress(), BiTuple.of(memberInfo, preJoinOperation))) == null) {
            this.clusterJoinManager.sendMasterAnswer(memberInfo.getAddress());
            if (now - this.firstJoinRequest < this.maxWaitMillisBeforeJoin) {
                this.timeToStartJoin = now + this.waitMillisBeforeJoin;
            }
        } else if (!existing.element1().getUuid().equals(memberInfo.getUuid())) {
            this.logger.warning("Received a new join request from " + String.valueOf(memberInfo.getAddress()) + " with a new UUID " + String.valueOf(memberInfo.getUuid()) + ". Previous UUID was " + String.valueOf(existing.element1().getUuid()));
        }
        if (!this.clusterJoinManager.isBatchingJoins(now)) {
            this.clusterJoinManager.startJoin(memberInfo, preJoinOperation);
        }
    }

    void reset() {
        this.timeToStartJoin = Clock.currentTimeMillis() + this.waitMillisBeforeJoin;
        this.firstJoinRequest = 0L;
    }
}

