/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.executor.LocalExecutorStats;
import com.hazelcast.executor.impl.ExecutorServiceProxy;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.ExecutorStats;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DistributedExecutorService
implements ManagedService,
RemoteService,
StatisticsAwareService<LocalExecutorStatsImpl>,
SplitBrainProtectionAwareService,
DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:impl:executorService";
    private static final Object NULL_OBJECT = new Object();
    private static final AtomicReferenceFieldUpdater<Processor, Boolean> RESPONSE_FLAG = AtomicReferenceFieldUpdater.newUpdater(Processor.class, Boolean.class, "responseFlag");
    final ConcurrentMap<String, ExecutorConfig> executorConfigCache = new ConcurrentHashMap<String, ExecutorConfig>();
    private NodeEngine nodeEngine;
    private ExecutionService executionService;
    private final ConcurrentMap<UUID, Processor> submittedTasks = new ConcurrentHashMap<UUID, Processor>();
    private final Set<String> shutdownExecutors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ExecutorStats executorStats = new ExecutorStats();
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            ExecutorConfig executorConfig = DistributedExecutorService.this.nodeEngine.getConfig().findExecutorConfig(name);
            String splitBrainProtectionName = executorConfig.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };
    private ILogger logger;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        this.executionService = nodeEngine.getExecutionService();
        this.logger = nodeEngine.getLogger(DistributedExecutorService.class);
        nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
    }

    @Override
    public void reset() {
        this.shutdownExecutors.clear();
        this.submittedTasks.clear();
        this.executorStats.clear();
        this.executorConfigCache.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public <T> void execute(String name, UUID uuid, @Nonnull T task, Operation op) {
        Processor processor;
        ExecutorConfig cfg = this.getOrFindExecutorConfig(name);
        if (cfg.isStatisticsEnabled()) {
            this.executorStats.startPending(name);
        }
        if (task instanceof Runnable) {
            Runnable runnable = (Runnable)task;
            processor = new Processor(name, uuid, runnable, op, cfg.isStatisticsEnabled(), cfg.getUserCodeNamespace());
        } else if (task instanceof Callable) {
            Callable callable = (Callable)task;
            processor = new Processor(name, uuid, callable, op, cfg.isStatisticsEnabled(), cfg.getUserCodeNamespace());
        } else {
            throw new IllegalArgumentException(task.getClass().getName());
        }
        if (uuid != null) {
            this.submittedTasks.put(uuid, processor);
        }
        try {
            this.executionService.execute(name, processor);
        }
        catch (RejectedExecutionException e) {
            if (cfg.isStatisticsEnabled()) {
                this.executorStats.rejectExecution(name);
            }
            this.logger.warning("While executing " + String.valueOf(task) + " on Executor[" + name + "]", e);
            if (uuid != null) {
                this.submittedTasks.remove(uuid);
            }
            processor.sendResponse(e);
        }
    }

    public boolean cancel(UUID uuid, boolean interrupt) {
        Processor processor = (Processor)this.submittedTasks.remove(uuid);
        if (processor != null && processor.cancel(interrupt) && processor.sendResponse(new CancellationException())) {
            if (processor.isStatisticsEnabled()) {
                this.executorStats.cancelExecution(processor.name);
            }
            return true;
        }
        return false;
    }

    public String getName(UUID uuid) {
        Processor proc = (Processor)this.submittedTasks.get(uuid);
        if (proc != null) {
            return proc.name;
        }
        return null;
    }

    public void shutdownExecutor(String name) {
        this.executionService.shutdownExecutor(name);
        this.shutdownExecutors.add(name);
        this.executorConfigCache.remove(name);
    }

    public boolean isShutdown(String name) {
        return this.shutdownExecutors.contains(name);
    }

    @Override
    public ExecutorServiceProxy createDistributedObject(String name, UUID source, boolean local) {
        return new ExecutorServiceProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        this.shutdownExecutors.remove(name);
        this.executionService.shutdownExecutor(name);
        this.executorStats.removeStats(name);
        this.executorConfigCache.remove(name);
        this.splitBrainProtectionConfigCache.remove(name);
    }

    @Override
    public Map<String, LocalExecutorStatsImpl> getStats() {
        return this.executorStats.getStatsMap();
    }

    private ExecutorConfig getOrFindExecutorConfig(String name) {
        ExecutorConfig cfg = (ExecutorConfig)this.executorConfigCache.get(name);
        if (cfg != null) {
            return cfg;
        }
        cfg = this.nodeEngine.getConfig().findExecutorConfig(name);
        ExecutorConfig executorConfig = this.executorConfigCache.putIfAbsent(name, cfg);
        return executorConfig == null ? cfg : executorConfig;
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        if (name == null) {
            return null;
        }
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "executor", this.getStats());
    }

    public LocalExecutorStats getLocalExecutorStats(String name) {
        return this.executorStats.getLocalExecutorStats(name, false);
    }

    public static String lookupNamespace(NodeEngine engine, String executorName) {
        DistributedExecutorService service;
        ExecutorConfig config;
        if (engine.getNamespaceService().isEnabled() && (config = (service = (DistributedExecutorService)engine.getService(SERVICE_NAME)).getOrFindExecutorConfig(executorName)) != null) {
            return config.getUserCodeNamespace();
        }
        return null;
    }

    private final class Processor
    extends FutureTask
    implements Runnable {
        volatile Boolean responseFlag;
        private final String name;
        private final UUID uuid;
        private final Operation op;
        private final String taskToString;
        private final long creationTime;
        private final boolean statisticsEnabled;
        @Nullable
        private final String namespace;

        private Processor(String name, @Nonnull UUID uuid, Callable callable, Operation op, @Nullable boolean statisticsEnabled, String namespace) {
            super(callable);
            this.responseFlag = Boolean.FALSE;
            this.creationTime = Clock.currentTimeMillis();
            this.name = name;
            this.uuid = uuid;
            this.taskToString = String.valueOf(callable);
            this.op = op;
            this.statisticsEnabled = statisticsEnabled;
            this.namespace = namespace;
        }

        private Processor(String name, @Nonnull UUID uuid, Runnable runnable, Operation op, @Nullable boolean statisticsEnabled, String namespace) {
            super(runnable, null);
            this.responseFlag = Boolean.FALSE;
            this.creationTime = Clock.currentTimeMillis();
            this.name = name;
            this.uuid = uuid;
            this.taskToString = String.valueOf(runnable);
            this.op = op;
            this.statisticsEnabled = statisticsEnabled;
            this.namespace = namespace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = Clock.currentTimeMillis();
            if (this.statisticsEnabled) {
                DistributedExecutorService.this.executorStats.startExecution(this.name, start - this.creationTime);
            }
            Exception result = null;
            try {
                NamespaceUtil.setupNamespace(DistributedExecutorService.this.nodeEngine, this.namespace);
                super.run();
                if (!this.isCancelled()) {
                    result = this.get();
                }
            }
            catch (Exception e) {
                this.logException(e);
                result = e;
            }
            finally {
                if (this.uuid != null) {
                    DistributedExecutorService.this.submittedTasks.remove(this.uuid);
                }
                if (!this.isCancelled()) {
                    this.sendResponse(result);
                    if (this.statisticsEnabled) {
                        DistributedExecutorService.this.executorStats.finishExecution(this.name, Clock.currentTimeMillis() - start);
                    }
                }
                NamespaceUtil.cleanupNamespace(DistributedExecutorService.this.nodeEngine, this.namespace);
            }
        }

        private void logException(Exception e) {
            if (DistributedExecutorService.this.logger.isFinestEnabled()) {
                DistributedExecutorService.this.logger.finest("While executing callable: " + this.taskToString, e);
            }
        }

        private boolean sendResponse(Object result) {
            if (RESPONSE_FLAG.compareAndSet(this, Boolean.FALSE, Boolean.TRUE)) {
                try {
                    this.op.sendResponse(result);
                }
                catch (HazelcastSerializationException e) {
                    this.op.sendResponse(e);
                }
                return true;
            }
            return false;
        }

        boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }
    }
}

