/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.AbstractWanPublisherConfig;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.enterprise.wan.impl.AbstractWanAntiEntropyEvent;
import com.hazelcast.enterprise.wan.impl.FinalizableEnterpriseWanEvent;
import com.hazelcast.enterprise.wan.impl.WanConsistencyCheckEvent;
import com.hazelcast.enterprise.wan.impl.WanSyncEvent;
import com.hazelcast.enterprise.wan.impl.replication.AbstractWanReplication;
import com.hazelcast.enterprise.wan.impl.replication.BatchReplicationStrategy;
import com.hazelcast.enterprise.wan.impl.replication.ConcurrentBatchReplicationStrategy;
import com.hazelcast.enterprise.wan.impl.replication.DefaultWanBatchSender;
import com.hazelcast.enterprise.wan.impl.replication.LatencyTrackingWanBatchSender;
import com.hazelcast.enterprise.wan.impl.replication.SerialBatchReplicationStrategy;
import com.hazelcast.enterprise.wan.impl.replication.WanBatchSender;
import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.enterprise.wan.impl.replication.WanPublisherFullSyncSupport;
import com.hazelcast.enterprise.wan.impl.replication.WanPublisherMerkleTreeSyncSupport;
import com.hazelcast.enterprise.wan.impl.replication.WanPublisherSyncSupport;
import com.hazelcast.enterprise.wan.impl.replication.WanSyncException;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventResult;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateManager;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.StoreLatencyPlugin;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.map.impl.MerkleTreeNodeEntries;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.InternalWanEvent;
import com.hazelcast.wan.impl.WanAntiEntropyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class WanBatchPublisher
extends AbstractWanReplication
implements Runnable,
LiveOperationsTracker,
DynamicMetricsProvider {
    public static final String WAN_BATCH_SENDER_CLASS = "hazelcast.wan.wanBatchSenderClass";
    public static final String WAN_EXECUTOR = "hz:wan";
    public static final long THIRTY_SECONDS_IN_MS = TimeUnit.SECONDS.toMillis(30L);
    private static final int IDLE_MAX_SPINS = 20;
    private static final int IDLE_MAX_YIELDS = 50;
    protected WanBatchSender wanBatchSender;
    private final AtomicLong failedTransmitCount = new AtomicLong();
    private final Set<Operation> liveOperations = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReentrantLock syncLock = new ReentrantLock();
    private AtomicLong ongoingSyncInvocations = new AtomicLong();
    private volatile long lastBatchSendTime = System.currentTimeMillis();
    private volatile long lastFailedTransmitWarning;
    private Executor wanExecutor;
    private BlockingQueue<InternalWanEvent> syncEvents;
    private IdleStrategy idlingStrategy;
    private ArrayList<FinalizableEnterpriseWanEvent> eventBatchHolder;
    private BatchReplicationStrategy replicationStrategy;
    private BatchReplicationStrategy syncReplicationStrategy;

    @Override
    public void init(WanReplicationConfig wanReplicationConfig, AbstractWanPublisherConfig wanPublisherConfig) {
        super.init(wanReplicationConfig, wanPublisherConfig);
        this.idlingStrategy = new BackoffIdleStrategy(20L, 50L, this.configurationContext.getIdleMinParkNs(), this.configurationContext.getIdleMaxParkNs());
        this.wanExecutor = this.node.getNodeEngine().getExecutionService().getExecutor(WAN_EXECUTOR);
        this.wanBatchSender = this.createWanBatchSender(this.node);
        this.syncEvents = new LinkedBlockingQueue<InternalWanEvent>(this.configurationContext.getBatchSize());
        this.eventBatchHolder = new ArrayList(this.configurationContext.getBatchSize());
        int maxConcurrentInvocations = this.configurationContext.getMaxConcurrentInvocations();
        this.logger.fine("Initialising WAN batch publisher with " + maxConcurrentInvocations + " max invocations.");
        this.replicationStrategy = maxConcurrentInvocations > 1 ? new ConcurrentBatchReplicationStrategy(endpoints -> maxConcurrentInvocations) : new SerialBatchReplicationStrategy(this.node.getPartitionService().getPartitionCount());
        this.syncReplicationStrategy = new ConcurrentBatchReplicationStrategy(endpoints -> endpoints.size() * 3);
        this.wanExecutor.execute(this);
        this.node.nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
    }

    @Override
    public void run() {
        int idleCount = 0;
        while (this.running) {
            try {
                if (this.tryMakeProgress()) {
                    idleCount = 0;
                    continue;
                }
                this.idlingStrategy.idle(idleCount++);
            }
            catch (Exception e) {
                this.logger.severe("Exception occurred in WAN replication loop", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryMakeProgress() {
        List<Address> endpoints = this.getTargetEndpoints();
        if (endpoints.isEmpty()) {
            return false;
        }
        if (!this.syncEvents.isEmpty()) {
            Address syncEndpoint = this.syncReplicationStrategy.getNextEventBatchEndpoint(endpoints);
            if (syncEndpoint == null) {
                return false;
            }
            WanEventBatch batch = new WanEventBatch(this.configurationContext.isSnapshotEnabled());
            this.fillBatch(batch, this.configurationContext.getBatchSize());
            boolean sent = this.sendBatch(syncEndpoint, batch, true, Integer.MAX_VALUE);
            if (sent) {
                this.ongoingSyncInvocations.incrementAndGet();
            }
            return true;
        }
        Address endpoint = this.replicationStrategy.getNextEventBatchEndpoint(endpoints);
        if (endpoint == null) {
            return false;
        }
        if (this.state.isReplicateEnqueuedEvents() && this.syncLock.tryLock()) {
            WanEventBatch batch = null;
            int batchTerm = this.term.get();
            try {
                if (!this.hasOngoingSync()) {
                    batch = this.collectEventBatch(endpoint, endpoints);
                }
            }
            finally {
                this.syncLock.unlock();
            }
            if (batch != null) {
                this.sendBatch(endpoint, batch, false, batchTerm);
                return true;
            }
        }
        this.replicationStrategy.complete(endpoint);
        return false;
    }

    private void fillBatch(WanEventBatch batch, int batchSize) {
        boolean batchComplete;
        do {
            int n;
            InternalWanEvent syncEvent;
            if ((syncEvent = (InternalWanEvent)this.syncEvents.peek()) instanceof MerkleTreeNodeEntries) {
                MerkleTreeNodeEntries mtne = (MerkleTreeNodeEntries)((Object)syncEvent);
                n = mtne.getNodeEntries().size();
            } else {
                n = 1;
            }
            int syncEntryCount = n;
            int batchSizeWithThisEvent = batch.getTotalEntryCount() + syncEntryCount;
            if (batchSizeWithThisEvent <= batchSize || batch.isEmpty()) {
                this.syncEvents.poll();
                batch.addEvent(syncEvent);
                batchComplete = batchSizeWithThisEvent >= batchSize || this.syncEvents.isEmpty();
                continue;
            }
            batchComplete = true;
        } while (!batchComplete);
    }

    private boolean hasOngoingSync() {
        assert (this.syncLock.isHeldByCurrentThread());
        return !this.syncEvents.isEmpty() || this.ongoingSyncInvocations.get() > 0L;
    }

    private WanEventBatch collectEventBatch(Address endpoint, List<Address> endpoints) {
        boolean collectedAnyEvent;
        InternalPartitionService partitionService = this.node.getPartitionService();
        WanEventBatch batch = null;
        boolean collectionPeriodPassed = false;
        do {
            collectedAnyEvent = false;
            for (int partitionId = this.replicationStrategy.getFirstPartitionId(endpoint, endpoints); partitionId < partitionService.getPartitionCount() && !collectionPeriodPassed; partitionId += this.replicationStrategy.getPartitionIdStep(endpoint, endpoints)) {
                if (!partitionService.getPartition(partitionId).isLocal() || !this.replicationStrategy.assignPartitionToEndpoint(endpoint, partitionId)) continue;
                int elementsToDrain = this.configurationContext.getBatchSize() - (batch == null ? 0 : batch.getTotalEntryCount());
                this.eventBatchHolder.clear();
                this.eventQueueContainer.drainRandomWanQueue(partitionId, this.eventBatchHolder, elementsToDrain);
                for (InternalWanEvent internalWanEvent : this.eventBatchHolder) {
                    if (batch == null) {
                        batch = new WanEventBatch(this.configurationContext.isSnapshotEnabled());
                    }
                    batch.addEvent(internalWanEvent);
                    collectedAnyEvent = true;
                }
                int entryCount = batch == null ? 0 : batch.getTotalEntryCount();
                collectionPeriodPassed = entryCount >= this.configurationContext.getBatchSize() || this.sendingPeriodPassed() && entryCount > 0 || !this.running;
            }
        } while (!collectionPeriodPassed && !this.sendingPeriodPassed() && collectedAnyEvent);
        return batch;
    }

    private boolean sendingPeriodPassed() {
        long maxDelayMillis;
        long elapsedMillis = System.currentTimeMillis() - this.lastBatchSendTime;
        return elapsedMillis > (maxDelayMillis = this.configurationContext.getBatchMaxDelayMillis());
    }

    private boolean sendBatch(Address endpoint, WanEventBatch batch, boolean isSyncBatch, int batchTerm) {
        if (!this.running) {
            return false;
        }
        int currentTerm = this.term.get();
        if (!isSyncBatch && currentTerm > batchTerm) {
            this.logger.fine("Dropped an in-flight wan event batch because replication queue is cleared. eventCount=" + batch.getPrimaryEventCount() + ", currentTerm=" + currentTerm + ", batchTerm=" + batchTerm);
            this.handleWanBatchResponse(batch, endpoint, true, false, batchTerm);
            return true;
        }
        try {
            InternalCompletableFuture<Boolean> future = this.wanBatchSender.send(batch, endpoint);
            future.whenCompleteAsync((response, t) -> {
                try {
                    if (t == null) {
                        this.handleWanBatchResponse(batch, endpoint, (boolean)response, isSyncBatch, batchTerm);
                    } else {
                        this.handleWanBatchError(batch, endpoint, (Throwable)t, isSyncBatch, batchTerm);
                    }
                }
                catch (Exception e) {
                    this.logger.warning("An exception occurred while handling a batch response.", e);
                }
            }, this.wanExecutor);
            this.lastBatchSendTime = System.currentTimeMillis();
        }
        catch (Throwable t2) {
            this.handleWanBatchError(batch, endpoint, t2, isSyncBatch, batchTerm);
        }
        return true;
    }

    private void handleWanBatchResponse(WanEventBatch batch, Address endpoint, boolean response, boolean isSyncBatch, int batchTerm) {
        if (response) {
            for (InternalWanEvent sentEvent : batch.getEvents()) {
                this.incrementEventCount(sentEvent);
            }
            this.finalizeWanEventReplication(batch.getEvents(), batch.getCoalescedEvents());
            if (isSyncBatch) {
                this.syncReplicationStrategy.complete(endpoint);
            } else {
                this.replicationStrategy.complete(endpoint);
            }
            this.wanCounter.decrementPrimaryElementCounter(batch.getPrimaryEventCount());
            if (isSyncBatch) {
                this.ongoingSyncInvocations.decrementAndGet();
            }
        } else {
            if (System.currentTimeMillis() - this.lastFailedTransmitWarning > THIRTY_SECONDS_IN_MS) {
                this.lastFailedTransmitWarning = System.currentTimeMillis();
                this.logger.warning(String.format("WAN transmission to '%s' failed; total failed transmissions (for all endpoints in publisher %s): %,d. These warnings are rate-limited, check the target member's output for more details.", endpoint.toString(), this.wanPublisherId, this.failedTransmitCount.get()));
            }
            this.failedTransmitCount.incrementAndGet();
            this.sendBatch(endpoint, batch, isSyncBatch, batchTerm);
        }
    }

    private void handleWanBatchError(WanEventBatch batch, Address endpoint, Throwable error, boolean isSyncBatch, int batchTerm) {
        this.logger.warning("Error occurred when sending WAN events to " + String.valueOf(endpoint), error);
        boolean connectionUnhealthy = error instanceof IOException;
        this.connectionManager.removeTargetEndpoint(endpoint, "Error occurred when sending WAN events to " + String.valueOf(endpoint), error, connectionUnhealthy);
        this.failedTransmitCount.incrementAndGet();
        this.sendBatch(endpoint, batch, isSyncBatch, batchTerm);
    }

    @Override
    protected WanPublisherSyncSupport createWanSyncSupport() {
        WanSyncConfig syncConfig = this.configurationContext.getPublisherConfig().getSyncConfig();
        if (syncConfig != null && ConsistencyCheckStrategy.MERKLE_TREES.equals((Object)syncConfig.getConsistencyCheckStrategy())) {
            return new WanPublisherMerkleTreeSyncSupport(this.node, this.configurationContext, this);
        }
        return new WanPublisherFullSyncSupport(this.node, this);
    }

    private WanBatchSender createWanBatchSender(Node node) {
        WanBatchSender sender = this.createBaseWanBatchSender(node);
        sender.init(node, this);
        Diagnostics diagnostics = node.getNodeEngine().getDiagnostics();
        StoreLatencyPlugin storeLatencyPlugin = diagnostics.getPlugin(StoreLatencyPlugin.class);
        return storeLatencyPlugin != null ? new LatencyTrackingWanBatchSender(sender, storeLatencyPlugin, this.wanPublisherId, this.wanExecutor) : sender;
    }

    protected WanBatchSender createBaseWanBatchSender(Node node) {
        String senderClass = System.getProperty(WAN_BATCH_SENDER_CLASS);
        if (StringUtil.isNullOrEmpty(senderClass)) {
            return new DefaultWanBatchSender();
        }
        try {
            return (WanBatchSender)ClassLoaderUtil.newInstance(NamespaceUtil.getDefaultClassloader(node.getNodeEngine()), senderClass);
        }
        catch (Exception e) {
            throw new HazelcastException("Could not construct WAN batch sender", e);
        }
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        descriptor.withPrefix("wan");
        MetricDescriptor enriched = descriptor.copy().withMetric("connectionHealth").withTag("discoveryStrategy", "static").withUnit(ProbeUnit.BOOLEAN);
        for (Address address : this.connectionManager.getTargetEndpoints()) {
            context.collect(enriched.withDiscriminator("address", address.toString()), 1L);
        }
        for (Address address : this.discoveryService.getUnhealthyEndpoints()) {
            context.collect(enriched.withDiscriminator("address", address.toString()), 0L);
        }
        context.collect(descriptor.copy().withMetric("failedTransmitCount").withUnit(ProbeUnit.COUNT), this.failedTransmitCount.get());
    }

    @Override
    public void publishAntiEntropyEvent(WanAntiEntropyEvent wanAntiEntropyEvent) {
        AbstractWanAntiEntropyEvent event = (AbstractWanAntiEntropyEvent)wanAntiEntropyEvent;
        this.liveOperations.add(event.getOp());
        this.wanExecutor.execute(() -> {
            event.setProcessingResult(new WanAntiEntropyEventResult());
            try {
                if (event instanceof WanSyncEvent) {
                    WanSyncEvent syncEvent = (WanSyncEvent)event;
                    this.syncLock.lock();
                    try {
                        this.syncSupport.processEvent(syncEvent);
                    }
                    catch (WanSyncException e) {
                        this.logger.warning("During wan sync, a problem occurred. Sync UUID: " + String.valueOf(event.getUuid()), e);
                    }
                    finally {
                        this.syncLock.unlock();
                    }
                    return;
                }
                if (event instanceof WanConsistencyCheckEvent) {
                    WanConsistencyCheckEvent checkEvent = (WanConsistencyCheckEvent)event;
                    this.syncSupport.processEvent(checkEvent);
                    return;
                }
                this.logger.info("Ignoring unknown WAN anti-entropy event " + String.valueOf(event));
            }
            catch (Exception ex) {
                this.logger.warning("WAN anti-entropy event " + String.valueOf(event) + " processing failed", ex);
                this.wanService.getSyncManager().getWanSyncStateManager().finishLocal(event.getUuid(), WanSyncStateManager.WanSyncStateStage.FAILED);
            }
            finally {
                event.sendResponse();
                this.liveOperations.remove(event.getOp());
            }
        });
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        for (Operation op : this.liveOperations) {
            liveOperations.add(op.getCallerAddress(), op.getCallId());
        }
    }

    public long getFailedTransmissionCount() {
        return this.failedTransmitCount.get();
    }

    Executor getWanExecutor() {
        return this.wanExecutor;
    }

    void putToSyncEventQueue(InternalWanEvent event) {
        try {
            this.syncEvents.put(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    public boolean hasOngoingReplication() {
        return this.replicationStrategy.hasOngoingReplication() || this.syncReplicationStrategy.hasOngoingReplication();
    }
}

