/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.discovery;

import com.hazelcast.cluster.Address;
import com.hazelcast.enterprise.wan.impl.discovery.StaticDiscoveryProperties;
import com.hazelcast.enterprise.wan.impl.discovery.UnresolvableStaticDiscoveryNode;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;

public class StaticDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    public StaticDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        String endpoints = this.getOrDefault(StaticDiscoveryProperties.ENDPOINTS, "");
        Integer port = this.getOrDefault(StaticDiscoveryProperties.PORT, 5432);
        ArrayList<DiscoveryNode> ret = new ArrayList<DiscoveryNode>();
        for (String endpoint : endpoints.split(",")) {
            String trimmedEndpoint = endpoint.trim();
            try {
                if (StringUtil.isNullOrEmpty(trimmedEndpoint)) continue;
                AddressUtil.AddressHolder holder = AddressUtil.getAddressHolder(trimmedEndpoint, port);
                Address addr = new Address(holder.getAddress(), holder.getPort());
                ret.add(new SimpleDiscoveryNode(addr, addr));
            }
            catch (UnknownHostException e) {
                EmptyStatement.ignore(e);
                ret.add(new UnresolvableStaticDiscoveryNode(trimmedEndpoint));
            }
        }
        return ret;
    }
}

