/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.discovery;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.enterprise.wan.impl.discovery.ConnectionHealthData;
import com.hazelcast.enterprise.wan.impl.discovery.StaticDiscoveryProperties;
import com.hazelcast.enterprise.wan.impl.discovery.StaticDiscoveryStrategy;
import com.hazelcast.enterprise.wan.impl.discovery.UnresolvableStaticDiscoveryNode;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class HealthTrackingStaticDiscoveryStrategy
extends StaticDiscoveryStrategy
implements ConnectionListener<ServerConnection> {
    public static final String HEALTHY_ENDPOINT_VALUE = "True";
    private static final Map<String, String> HEALTHY_ENDPOINT_PROPERTIES = new HashMap<String, String>(1);
    private static final Map<String, String> UNHEALTHY_ENDPOINT_PROPERTIES = new HashMap<String, String>(1);
    private static final long DEFAULT_HEALTH_CHECK_INITIAL_DELAY_MS = 1000L;
    private static final long DEFAULT_HEALTH_CHECK_INTERVAL_MS = 10000L;
    private static final int DEFAULT_HEALTH_CHECK_TIMEOUT_MS = 3000;
    private static final int DEFAULT_HEALTH_CHECK_MAX_FAILED_PROBES = 10;
    private static final boolean DEFAULT_HEALTH_CHECK_EAGER_FIRST_CHECK = false;
    private static final long DEFAULT_HEALTH_CHECK_BACK_OFF_DELAY_STEP_MS = 5000L;
    private static final int DEFAULT_HEALTH_CHECK_BACK_OFF_MAX_STEPS = 12;
    private final Map<Address, ConnectionHealthData> unhealthyEndpoints = new ConcurrentHashMap<Address, ConnectionHealthData>();
    private final ScheduledExecutorService scheduledExecutor;
    private final long healthCheckInitialDelay;
    private final long healthCheckInterval;
    private final int healthCheckTimeout;
    private final int healthCheckMaxFailedProbes;
    private final long healthCheckBackOffDelayStep;
    private final int healthCheckBackOffMaxSteps;
    private final AtomicBoolean checkAllEndpointsHealth = new AtomicBoolean(false);
    private final Node node;
    private final EndpointQualifier endpointQualifier;
    private Address pendingConnectionAddress;
    private CountDownLatch connectionEstablishedLatch;

    public HealthTrackingStaticDiscoveryStrategy(Node node, ILogger logger, String endpointIdentifier, Map<String, Comparable> properties) {
        super(logger, properties);
        this.node = node;
        this.endpointQualifier = endpointIdentifier == null ? EndpointQualifier.MEMBER : EndpointQualifier.resolve(ProtocolType.WAN, endpointIdentifier);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, HealthTrackingStaticDiscoveryStrategy.class.getSimpleName());
            thread.setDaemon(true);
            return thread;
        });
        node.getServer().getConnectionManager(this.endpointQualifier).addConnectionListener(this);
        this.healthCheckInitialDelay = this.getOrDefault(StaticDiscoveryProperties.HEALTH_CHECK_INITIAL_DELAY_MS, 1000L);
        this.healthCheckInterval = this.getOrDefault(StaticDiscoveryProperties.HEALTH_CHECK_INTERVAL_MS, 10000L);
        this.healthCheckTimeout = this.getOrDefault(StaticDiscoveryProperties.HEALTH_CHECK_TIMEOUT_MS, 3000);
        this.healthCheckMaxFailedProbes = this.getOrDefault(StaticDiscoveryProperties.HEALTH_CHECK_MAX_FAILED_PROBES, 10);
        boolean healthCheckEagerFirstCheck = this.getOrDefault(StaticDiscoveryProperties.HEALTH_CHECK_EAGER_FIRST_CHECK, false);
        if (healthCheckEagerFirstCheck) {
            this.checkAllEndpointsHealth.set(true);
        }
        this.healthCheckBackOffMaxSteps = this.getOrDefault(StaticDiscoveryProperties.HEALTH_CHECK_BACK_OFF_MAX_STEPS, 12);
        this.healthCheckBackOffDelayStep = this.getOrDefault(StaticDiscoveryProperties.HEALTH_CHECK_BACK_OFF_DELAY_STEP_MS, 5000L);
    }

    @Override
    public void start() {
        super.start();
        this.scheduledExecutor.scheduleWithFixedDelay(this::healthCheckAllUnhealthyEndpoints, this.healthCheckInitialDelay, this.healthCheckInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.scheduledExecutor.shutdownNow();
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        String endpoints = this.getOrDefault(StaticDiscoveryProperties.ENDPOINTS, "");
        Integer port = this.getOrDefault(StaticDiscoveryProperties.PORT, 5432);
        ArrayList<DiscoveryNode> ret = new ArrayList<DiscoveryNode>();
        for (String endpoint : endpoints.split(",")) {
            String trimmedEndpoint = endpoint.trim();
            try {
                if (StringUtil.isNullOrEmpty(trimmedEndpoint)) continue;
                AddressUtil.AddressHolder holder = AddressUtil.getAddressHolder(trimmedEndpoint, port);
                Address addr = new Address(holder.getAddress(), holder.getPort());
                if (this.checkAllEndpointsHealth.get()) {
                    this.unhealthyEndpoints.put(addr, new ConnectionHealthData());
                    ret.add(new SimpleDiscoveryNode(addr, UNHEALTHY_ENDPOINT_PROPERTIES));
                    continue;
                }
                ConnectionHealthData data = this.unhealthyEndpoints.get(addr);
                if (data != null) {
                    if (this.checkConnectionActive(addr)) {
                        this.unhealthyEndpoints.remove(addr);
                        data = null;
                    } else {
                        data.markProbe();
                    }
                }
                ret.add(new SimpleDiscoveryNode(addr, data != null ? UNHEALTHY_ENDPOINT_PROPERTIES : HEALTHY_ENDPOINT_PROPERTIES));
            }
            catch (UnknownHostException e) {
                EmptyStatement.ignore(e);
                ret.add(new UnresolvableStaticDiscoveryNode(trimmedEndpoint));
            }
        }
        this.checkAllEndpointsHealth.set(false);
        return ret;
    }

    @Override
    public void markEndpointAsUnhealthy(Address address) {
        if (this.unhealthyEndpoints.putIfAbsent(address, new ConnectionHealthData()) == null) {
            this.getLogger().warning(String.format("WAN target endpoint %s is unreachable - its health will be probed periodically", address));
        }
    }

    @Override
    public Set<Address> getUnhealthyEndpoints() {
        return this.unhealthyEndpoints.keySet();
    }

    private void healthCheckAllUnhealthyEndpoints() {
        this.getLogger().fine("Starting health check for all unhealthy endpoints");
        long startTime = Clock.currentTimeMillis();
        Iterator<Map.Entry<Address, ConnectionHealthData>> iterator = this.unhealthyEndpoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Address, ConnectionHealthData> entry = iterator.next();
            Address address = entry.getKey();
            ConnectionHealthData data = entry.getValue();
            if (data.shouldAttemptConnect(this.healthCheckBackOffDelayStep, this.healthCheckBackOffMaxSteps) && data.isRecentlyProbed()) {
                try {
                    if (this.checkLiveliness(address)) {
                        iterator.remove();
                        this.getLogger().info(String.format("WAN target endpoint %s is now available again", address));
                        continue;
                    }
                    this.getLogger().fine(String.format("WAN target endpoint %s failed liveliness check. Total failed connection attempts: %d", address, data.getTotalFailedAttempts()));
                }
                catch (Exception ex) {
                    this.getLogger().warning("Failed to complete liveliness check for " + String.valueOf(address), ex);
                }
                data.markFailedConnectionAttempt();
                continue;
            }
            if (this.healthCheckMaxFailedProbes <= 0 || data.getFailedProbeChecks() < this.healthCheckMaxFailedProbes) continue;
            this.getLogger().fine(String.format("WAN target endpoint %s is unreachable and no longer found in discovery - removing from health probe checks.", address));
            iterator.remove();
        }
        long elapsed = Clock.currentTimeMillis() - startTime;
        this.getLogger().fine(String.format("Completed health check for all unhealthy endpoints (Took %,dms)", elapsed));
    }

    private boolean checkConnectionActive(Address remoteAddress) {
        ServerConnectionManager connectionManager = this.node.getServer().getConnectionManager(this.endpointQualifier);
        ServerConnection connection = connectionManager.get(remoteAddress);
        return connection != null && connection.isAlive();
    }

    private boolean checkLiveliness(Address remoteAddress) throws InterruptedException {
        ServerConnectionManager connectionManager = this.node.getServer().getConnectionManager(this.endpointQualifier);
        ServerConnection connection = connectionManager.get(remoteAddress);
        if (connection != null && connection.isAlive()) {
            return true;
        }
        if (this.connectionEstablishedLatch != null && this.connectionEstablishedLatch.getCount() != 0L) {
            throw new IllegalStateException("CountDownLatch is still in use - liveliness checks invoked from separate threads?");
        }
        this.pendingConnectionAddress = remoteAddress;
        this.connectionEstablishedLatch = new CountDownLatch(1);
        try {
            connection = connectionManager.getOrConnect(remoteAddress, true);
            if (connection != null && connection.isAlive()) {
                this.connectionEstablishedLatch = null;
                return true;
            }
            if (this.connectionEstablishedLatch.await(this.healthCheckTimeout, TimeUnit.MILLISECONDS)) {
                this.connectionEstablishedLatch = null;
                return true;
            }
        }
        catch (Exception exception) {
            this.getLogger().warning("Encountered issue while checking liveliness for " + String.valueOf(remoteAddress), exception);
        }
        this.connectionEstablishedLatch = null;
        return false;
    }

    @Override
    public void connectionAdded(ServerConnection connection) {
        if (this.connectionEstablishedLatch != null && connection.getRemoteAddress().equals(this.pendingConnectionAddress)) {
            this.connectionEstablishedLatch.countDown();
        }
    }

    @Override
    public void connectionRemoved(ServerConnection connection) {
    }

    @Override
    protected <T extends Comparable> T getOrDefault(PropertyDefinition property, T defaultValue) {
        Comparable value = this.getProperties().get(property.key());
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            value = property.typeConverter().convert(value);
        }
        return (T)value;
    }

    static {
        HEALTHY_ENDPOINT_PROPERTIES.put("healthy", HEALTHY_ENDPOINT_VALUE);
        UNHEALTHY_ENDPOINT_PROPERTIES.put("healthy", "False");
    }
}

