/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.discovery;

import com.hazelcast.internal.util.Clock;

class ConnectionHealthData {
    private long lastConnectionAttempt;
    private int totalFailedAttempts;
    private int failedProbeChecks;
    private boolean recentlyProbed;

    ConnectionHealthData() {
    }

    public void markProbe() {
        this.recentlyProbed = true;
    }

    public void markFailedConnectionAttempt() {
        this.lastConnectionAttempt = Clock.currentTimeMillis();
        ++this.totalFailedAttempts;
        this.recentlyProbed = false;
    }

    public long getLastConnectionAttempt() {
        return this.lastConnectionAttempt;
    }

    public int getTotalFailedAttempts() {
        return this.totalFailedAttempts;
    }

    public int getFailedProbeChecks() {
        return this.failedProbeChecks;
    }

    public boolean isRecentlyProbed() {
        if (this.recentlyProbed) {
            this.failedProbeChecks = 0;
            this.recentlyProbed = false;
            return true;
        }
        ++this.failedProbeChecks;
        return false;
    }

    public boolean shouldAttemptConnect(long healthCheckBackOffDelayStep, int healthCheckBackOffMaxSteps) {
        int flooredAttempts = Math.min(healthCheckBackOffMaxSteps, this.totalFailedAttempts);
        return this.lastConnectionAttempt + (long)flooredAttempts * healthCheckBackOffDelayStep <= Clock.currentTimeMillis();
    }
}

