/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.config.AbstractWanPublisherConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.enterprise.wan.impl.AbstractWanAntiEntropyEvent;
import com.hazelcast.enterprise.wan.impl.WanAcknowledger;
import com.hazelcast.enterprise.wan.impl.WanConsistencyCheckEvent;
import com.hazelcast.enterprise.wan.impl.WanConsumerContainer;
import com.hazelcast.enterprise.wan.impl.WanEventProcessor;
import com.hazelcast.enterprise.wan.impl.WanMigrationAwareService;
import com.hazelcast.enterprise.wan.impl.WanNonThrottlingAcknowledger;
import com.hazelcast.enterprise.wan.impl.WanSchemeContainer;
import com.hazelcast.enterprise.wan.impl.WanSyncEvent;
import com.hazelcast.enterprise.wan.impl.WanThrottlingAcknowledger;
import com.hazelcast.enterprise.wan.impl.operation.AddWanConfigOperation;
import com.hazelcast.enterprise.wan.impl.operation.AddWanConfigOperationFactory;
import com.hazelcast.enterprise.wan.impl.operation.PostJoinWanOperation;
import com.hazelcast.enterprise.wan.impl.operation.WanEventContainerOperation;
import com.hazelcast.enterprise.wan.impl.replication.AbstractWanPublisher;
import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncManager;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.management.events.AbstractWanConfigurationEventBase;
import com.hazelcast.internal.management.events.Event;
import com.hazelcast.internal.management.events.WanAddConfigurationIgnoredEvent;
import com.hazelcast.internal.management.events.WanConfigurationAddedEvent;
import com.hazelcast.internal.management.events.WanConfigurationExtendedEvent;
import com.hazelcast.internal.management.events.WanConsistencyCheckIgnoredEvent;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.monitor.LocalWanPublisherStats;
import com.hazelcast.internal.monitor.LocalWanStats;
import com.hazelcast.internal.monitor.WanSyncState;
import com.hazelcast.internal.monitor.impl.LocalWanPublisherStatsImpl;
import com.hazelcast.internal.monitor.impl.LocalWanStatsImpl;
import com.hazelcast.internal.partition.ChunkedMigrationAwareService;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.PostJoinAwareService;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.version.Version;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanPublisher;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.wan.impl.ConsistencyCheckResult;
import com.hazelcast.wan.impl.DelegatingWanScheme;
import com.hazelcast.wan.impl.InternalWanEvent;
import com.hazelcast.wan.impl.InternalWanPublisher;
import com.hazelcast.wan.impl.WanEventCounterRegistry;
import com.hazelcast.wan.impl.WanReplicationService;
import com.hazelcast.wan.impl.WanReplicationServiceImpl;
import com.hazelcast.wan.impl.WanSyncStateResult;
import com.hazelcast.wan.impl.WanSyncStats;
import com.hazelcast.wan.impl.WanSyncType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnterpriseWanReplicationService
implements WanReplicationService,
ChunkedMigrationAwareService,
PostJoinAwareService,
LiveOperationsTracker,
ManagedService,
DynamicMetricsProvider {
    public static final String PROP_ADD_WAN_CONFIG_MAX_RETRIES = "hazelcast.internal.add.wan.config.max.retry";
    public static final Version COMPACT_SUPPORTED_WAN_PROTOCOL_VERSION = Version.of(1, 1);
    private static final int HUNDRED = 100;
    private static final int DEFAULT_ADD_WAN_CONFIG_MAX_RETRIES = 10;
    private static final HazelcastProperty ADD_WAN_CONFIG_MAX_RETRIES = new HazelcastProperty("hazelcast.internal.add.wan.config.max.retry", 10);
    private final List<Version> supportedWanProtocolVersions = new ArrayList<Version>(Arrays.asList(Version.of(1, 1), Version.of(1, 0)));
    private final Node node;
    private final ILogger logger;
    private final WanMigrationAwareService migrationAwareService;
    private final WanEventProcessor eventProcessor;
    private final WanSchemeContainer publisherContainer;
    private final WanConsumerContainer consumerContainer;
    private final WanSyncManager syncManager;
    private final Object configUpdateMutex = new Object();
    private final WanEventCounterRegistry receivedWanEventCounters = new WanEventCounterRegistry();
    private final WanEventCounterRegistry sentWanEventCounters = new WanEventCounterRegistry();
    private final WanAcknowledger acknowledger;
    private final int addWanConfigMaxRetry;

    public EnterpriseWanReplicationService(Node node) {
        this.node = node;
        this.logger = node.getLogger(EnterpriseWanReplicationService.class.getName());
        this.migrationAwareService = new WanMigrationAwareService(this, node);
        this.acknowledger = this.createAcknowledger();
        this.eventProcessor = new WanEventProcessor(node, this.acknowledger);
        this.publisherContainer = new WanSchemeContainer(node);
        this.consumerContainer = new WanConsumerContainer(node);
        this.syncManager = new WanSyncManager(this, node);
        this.addWanConfigMaxRetry = node.getProperties().getInteger(ADD_WAN_CONFIG_MAX_RETRIES);
    }

    private WanAcknowledger createAcknowledger() {
        HazelcastProperties properties = this.node.getProperties();
        int invocationThreshold = properties.getInteger(ClusterProperty.WAN_CONSUMER_INVOCATION_THRESHOLD);
        if (invocationThreshold <= 0) {
            return new WanNonThrottlingAcknowledger(this.node);
        }
        return new WanThrottlingAcknowledger(this.node, invocationThreshold);
    }

    public WanPublisher getPublisherOrNull(String wanReplicationName, String wanPublisherId) {
        if (!this.hasWanReplicationScheme(wanReplicationName)) {
            return null;
        }
        return this.getWanReplicationPublishers(wanReplicationName).getPublisher(wanPublisherId);
    }

    @Override
    public WanPublisher getPublisherOrFail(String wanReplicationName, String wanPublisherId) {
        WanPublisher publisher = this.getPublisherOrNull(wanReplicationName, wanPublisherId);
        if (publisher == null) {
            throw new InvalidConfigurationException("WAN Replication Config doesn't exist with WAN configuration name " + wanReplicationName + " and publisher ID " + wanPublisherId);
        }
        return publisher;
    }

    public void handleEvent(IdentifiedDataSerializable event, WanEventContainerOperation wanOperation) {
        if (event instanceof WanEventBatch) {
            WanEventBatch batch = (WanEventBatch)event;
            this.eventProcessor.handleRepEvent(batch, wanOperation);
        } else {
            this.eventProcessor.handleRepEvent((InternalWanEvent)event, wanOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendWanReplicationConfig(WanReplicationConfig newConfig) {
        String scheme = newConfig.getName();
        ConcurrentMap wanConfigs = (ConcurrentMap)this.node.getConfig().getWanReplicationConfigs();
        WanReplicationConfig existingConfig = wanConfigs.putIfAbsent(scheme, newConfig);
        if (existingConfig == null) {
            this.logger.info("Added new WAN replication configuration " + String.valueOf(newConfig));
            return true;
        }
        Map<String, WanBatchPublisherConfig> missingBatchPublishers = this.removeExistingPublishers(EnterpriseWanReplicationService.getPublisherConfigMap(newConfig.getBatchPublisherConfigs()), existingConfig.getBatchPublisherConfigs());
        Map<String, WanCustomPublisherConfig> missingCustomPublishers = this.removeExistingPublishers(EnterpriseWanReplicationService.getPublisherConfigMap(newConfig.getCustomPublisherConfigs()), existingConfig.getCustomPublisherConfigs());
        if (missingBatchPublishers.isEmpty() && missingCustomPublishers.isEmpty()) {
            return false;
        }
        Object object = this.configUpdateMutex;
        synchronized (object) {
            existingConfig = (WanReplicationConfig)wanConfigs.get(scheme);
            this.removeExistingPublishers(missingBatchPublishers, existingConfig.getBatchPublisherConfigs());
            this.removeExistingPublishers(missingCustomPublishers, existingConfig.getCustomPublisherConfigs());
            if (missingBatchPublishers.isEmpty() && missingCustomPublishers.isEmpty()) {
                return false;
            }
            WanReplicationConfig mergedConfig = new WanReplicationConfig();
            mergedConfig.setConsumerConfig(existingConfig.getConsumerConfig());
            mergedConfig.setName(existingConfig.getName());
            mergedConfig.getBatchPublisherConfigs().addAll(existingConfig.getBatchPublisherConfigs());
            mergedConfig.getBatchPublisherConfigs().addAll(missingBatchPublishers.values());
            mergedConfig.getCustomPublisherConfigs().addAll(existingConfig.getCustomPublisherConfigs());
            mergedConfig.getCustomPublisherConfigs().addAll(missingCustomPublishers.values());
            wanConfigs.put(scheme, mergedConfig);
            this.logger.info("Added new WAN publisher configurations " + String.valueOf(missingBatchPublishers.values()) + " to WAN replication scheme: " + scheme);
            return true;
        }
    }

    private <T extends AbstractWanPublisherConfig> Map<String, T> removeExistingPublishers(Map<String, T> toRemoveFrom, Collection<T> toRemove) {
        for (AbstractWanPublisherConfig c : toRemove) {
            toRemoveFrom.remove(WanReplicationServiceImpl.getWanPublisherId(c));
        }
        return toRemoveFrom;
    }

    void emitManagementCenterEvent(Event event) {
        if (this.node.getManagementCenterService() != null) {
            this.node.getManagementCenterService().log(event);
        }
    }

    private static <T extends AbstractWanPublisherConfig> Map<String, T> getPublisherConfigMap(Collection<T> publisherConfigs) {
        return publisherConfigs.stream().collect(Collectors.toMap(WanReplicationServiceImpl::getWanPublisherId, Function.identity()));
    }

    public void publishAntiEntropyEvent(AbstractWanAntiEntropyEvent event) {
        WanPublisher publisher = this.getPublisherOrFail(event.getWanReplicationName(), event.getWanPublisherId());
        if (publisher instanceof InternalWanPublisher) {
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            this.syncManager.setActiveWanReplicationName(event.getWanReplicationName());
            this.syncManager.setActivePublisherId(event.getWanPublisherId());
            wanPublisher.publishAntiEntropyEvent(event);
        }
    }

    public WanSyncManager getSyncManager() {
        return this.syncManager;
    }

    public void initializeCustomConsumers() {
        this.consumerContainer.initializeCustomConsumers();
    }

    ConcurrentHashMap<String, DelegatingWanScheme> getWanReplications() {
        return this.publisherContainer.getWanReplications();
    }

    public void handleEvent(InternalWanEvent event, WanAcknowledgeType acknowledgeType) {
        this.eventProcessor.handleEvent(event, acknowledgeType);
    }

    @Override
    public boolean hasWanReplicationScheme(String wanReplicationScheme) {
        return this.publisherContainer.getWanReplications().containsKey(wanReplicationScheme) || this.node.getConfig().getWanReplicationConfig(wanReplicationScheme) != null;
    }

    @Override
    public DelegatingWanScheme getWanReplicationPublishers(String name) {
        return this.publisherContainer.getWanReplicationPublishers(name);
    }

    @Override
    public Map<String, LocalWanStats> getStats() {
        String wanReplicationConfigName;
        ConcurrentHashMap<String, DelegatingWanScheme> wanReplications = this.getWanReplications();
        Map<String, LocalWanStats> wanStats = MapUtil.createHashMap(wanReplications.size());
        for (Map.Entry<String, DelegatingWanScheme> delegateEntry : wanReplications.entrySet()) {
            LocalWanStatsImpl localWanStats = new LocalWanStatsImpl();
            wanReplicationConfigName = delegateEntry.getKey();
            DelegatingWanScheme delegate = delegateEntry.getValue();
            localWanStats.getLocalWanPublisherStats().putAll(delegate.getStats());
            wanStats.put(wanReplicationConfigName, localWanStats);
        }
        Map<String, WanReplicationConfig> wanReplicationConfigs = this.node.getNodeEngine().getConfig().getWanReplicationConfigs();
        for (Map.Entry<String, WanReplicationConfig> replicationEntry : wanReplicationConfigs.entrySet()) {
            wanReplicationConfigName = replicationEntry.getKey();
            if (wanStats.containsKey(wanReplicationConfigName)) continue;
            LocalWanStatsImpl localWanStats = new LocalWanStatsImpl();
            Map<String, LocalWanPublisherStats> publisherStats = localWanStats.getLocalWanPublisherStats();
            WanReplicationConfig replicationConfig = replicationEntry.getValue();
            for (WanBatchPublisherConfig config : replicationConfig.getBatchPublisherConfigs()) {
                String publisherId = WanReplicationServiceImpl.getWanPublisherId(config);
                LocalWanPublisherStatsImpl stats = new LocalWanPublisherStatsImpl();
                stats.setState(config.getInitialPublisherState());
                publisherStats.put(publisherId, stats);
            }
            wanStats.put(wanReplicationConfigName, localWanStats);
        }
        return wanStats;
    }

    @Override
    public WanSyncState getWanSyncState() {
        return this.syncManager.getWanSyncState();
    }

    @Override
    public WanEventCounters getReceivedEventCounters(String serviceName) {
        return this.receivedWanEventCounters.getWanEventCounter("", "", serviceName);
    }

    @Override
    public WanEventCounters getSentEventCounters(String wanReplicationName, String wanPublisherId, String serviceName) {
        return this.sentWanEventCounters.getWanEventCounter(wanReplicationName, wanPublisherId, serviceName);
    }

    @Override
    public void removeWanEventCounters(String serviceName, String dataStructureName) {
        this.receivedWanEventCounters.removeCounter(serviceName, dataStructureName);
        this.sentWanEventCounters.removeCounter(serviceName, dataStructureName);
    }

    @Override
    public List<Version> getSupportedWanProtocolVersions() {
        return this.supportedWanProtocolVersions;
    }

    @Override
    public Operation getPostJoinOperation() {
        Map<String, WanReplicationConfig> wanConfigs = this.node.getConfig().getWanReplicationConfigs();
        if (MapUtil.isNullOrEmpty(wanConfigs)) {
            return null;
        }
        return new PostJoinWanOperation(wanConfigs.values());
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        Collection<DelegatingWanScheme> publishers = this.getWanReplications().values();
        for (DelegatingWanScheme delegate : publishers) {
            for (WanPublisher publisher : delegate.getPublishers()) {
                if (!(publisher instanceof LiveOperationsTracker)) continue;
                LiveOperationsTracker tracker = (LiveOperationsTracker)((Object)publisher);
                tracker.populate(liveOperations);
            }
        }
        this.eventProcessor.populate(liveOperations);
    }

    @Override
    public void shutdown() {
        this.consumerContainer.shutdown();
        this.publisherContainer.shutdown();
    }

    @Override
    public void pause(String wanReplicationName, String wanPublisherId) {
        WanPublisher publisher = this.getPublisherOrFail(wanReplicationName, wanPublisherId);
        if (publisher instanceof InternalWanPublisher) {
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            wanPublisher.pause();
        }
    }

    @Override
    public void stop(String wanReplicationName, String wanPublisherId) {
        WanPublisher publisher = this.getPublisherOrFail(wanReplicationName, wanPublisherId);
        if (publisher instanceof InternalWanPublisher) {
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            wanPublisher.stop();
        }
    }

    @Override
    public void resume(String wanReplicationName, String wanPublisherId) {
        WanPublisher publisher = this.getPublisherOrFail(wanReplicationName, wanPublisherId);
        if (publisher instanceof InternalWanPublisher) {
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            wanPublisher.resume();
        }
    }

    @Override
    public UUID syncMap(String wanReplicationName, String wanPublisherId, String mapName) {
        this.node.getNodeExtension().getAuditlogService().eventBuilder("HZ-0201").message("Explicit request for WAN map synchronization").addParameter("replicationName", wanReplicationName).addParameter("publisherId", wanPublisherId).addParameter("mapName", mapName).log();
        WanSyncEvent event = new WanSyncEvent(wanReplicationName, wanPublisherId, mapName, WanSyncType.SINGLE_MAP);
        this.syncManager.initiateAntiEntropyRequest(event);
        return event.getUuid();
    }

    @Override
    public UUID syncAllMaps(String wanReplicationName, String wanPublisherId) {
        this.node.getNodeExtension().getAuditlogService().eventBuilder("HZ-0201").message("Explicit request for WAN all maps synchronization").addParameter("replicationName", wanReplicationName).addParameter("publisherId", wanPublisherId).log();
        WanSyncEvent event = new WanSyncEvent(wanReplicationName, wanPublisherId, null, WanSyncType.ALL_MAPS);
        this.syncManager.initiateAntiEntropyRequest(event);
        return event.getUuid();
    }

    @Override
    public UUID consistencyCheck(String wanReplicationName, String wanPublisherId, String mapName) {
        MerkleTreeConfig merkleTreeConfig = this.node.getConfig().findMapConfig(mapName).getMerkleTreeConfig();
        if (!Boolean.TRUE.equals(merkleTreeConfig.getEnabled())) {
            WanConsistencyCheckIgnoredEvent event = new WanConsistencyCheckIgnoredEvent(wanReplicationName, wanPublisherId, mapName, "Map has merkle trees disabled.");
            this.emitManagementCenterEvent(event);
            this.logger.info(String.format("Consistency check request for WAN replication '%s', publisher ID '%s' and map '%s' ignored because map has merkle trees disabled", wanReplicationName, wanPublisherId, mapName));
            return event.getUuid();
        }
        WanConsistencyCheckEvent event = new WanConsistencyCheckEvent(wanReplicationName, wanPublisherId, mapName);
        this.syncManager.initiateAntiEntropyRequest(event);
        return event.getUuid();
    }

    @Override
    public WanSyncStateResult getSyncResult(UUID syncUUID) {
        Version clusterVersion = this.node.getClusterService().getClusterVersion();
        if (!clusterVersion.isGreaterOrEqual(Versions.V5_3)) {
            this.logger.warning("Can't get sync result. Current cluster version: " + String.valueOf(clusterVersion) + " is less than " + String.valueOf(Versions.V5_3) + ".");
            return null;
        }
        return this.syncManager.getWanSyncStateManager().query(syncUUID);
    }

    @Override
    public void removeWanEvents(String wanReplicationName, String wanPublisherId) {
        WanPublisher publisher = this.getPublisherOrFail(wanReplicationName, wanPublisherId);
        if (publisher instanceof InternalWanPublisher) {
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            wanPublisher.removeWanEvents();
        }
    }

    @Override
    public void addWanReplicationConfigLocally(WanReplicationConfig wanReplicationConfig) {
        boolean configIsChanged = this.appendWanReplicationConfig(wanReplicationConfig);
        this.publisherContainer.ensurePublishersInitialized(wanReplicationConfig.getName());
        if (configIsChanged) {
            ConfigurationService configurationService = (ConfigurationService)this.node.getNodeEngine().getService("hz:configurationService");
            configurationService.persist(wanReplicationConfig);
            this.node.getNodeEngine().getServices(WanSupportingService.class).forEach(WanSupportingService::onWanConfigChange);
        }
    }

    @Override
    public AddWanConfigResult addWanReplicationConfig(WanReplicationConfig wanReplicationConfig) {
        AbstractWanConfigurationEventBase mcEvent;
        AddWanConfigResult result;
        WanReplicationConfig existingConfig = this.node.getConfig().getWanReplicationConfig(wanReplicationConfig.getName());
        Set<String> newPublisherIds = Stream.of(wanReplicationConfig.getBatchPublisherConfigs(), wanReplicationConfig.getCustomPublisherConfigs()).flatMap(Collection::stream).map(WanReplicationServiceImpl::getWanPublisherId).collect(Collectors.toSet());
        this.node.getNodeExtension().getAuditlogService().eventBuilder("HZ-0202").message("WAN Adding configuration").addParameter("newConfig", wanReplicationConfig).addParameter("existingConfig", existingConfig).log();
        if (existingConfig != null) {
            Set<String> ignoredPublisherIds = Stream.of(existingConfig.getBatchPublisherConfigs(), existingConfig.getCustomPublisherConfigs()).flatMap(Collection::stream).map(WanReplicationServiceImpl::getWanPublisherId).filter(newPublisherIds::contains).collect(Collectors.toSet());
            newPublisherIds.removeAll(ignoredPublisherIds);
            result = new AddWanConfigResult(newPublisherIds, ignoredPublisherIds);
            mcEvent = newPublisherIds.isEmpty() ? WanAddConfigurationIgnoredEvent.alreadyExists(wanReplicationConfig.getName()) : new WanConfigurationExtendedEvent(wanReplicationConfig.getName(), newPublisherIds);
        } else {
            mcEvent = new WanConfigurationAddedEvent(wanReplicationConfig.getName());
            result = new AddWanConfigResult(newPublisherIds, Collections.emptySet());
        }
        this.invokeAddWanReplicationConfig(wanReplicationConfig);
        this.emitManagementCenterEvent(mcEvent);
        return result;
    }

    private void invokeAddWanReplicationConfig(WanReplicationConfig wanReplicationConfig) {
        try {
            OperationServiceImpl operationService = this.node.getNodeEngine().getOperationService();
            operationService.invokeOnAllPartitions(null, new AddWanConfigOperationFactory(wanReplicationConfig));
            if (this.node.getClusterService().getClusterVersion().isUnknownOrLessThan(Versions.V4_1)) {
                this.addWanReplicationConfigLocally(wanReplicationConfig);
            } else {
                long timeoutMillis = this.node.nodeEngine.getProperties().getMillis(ClusterProperty.OPERATION_CALL_TIMEOUT_MILLIS);
                InvocationUtil.invokeOnStableClusterSerial(this.node.getNodeEngine(), () -> new AddWanConfigOperation(wanReplicationConfig, false), this.addWanConfigMaxRetry).get(timeoutMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        return this.migrationAwareService.getAllServiceNamespaces(event);
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return this.migrationAwareService.isKnownServiceNamespace(namespace);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        return this.migrationAwareService.prepareReplicationOperation(event, namespaces);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.migrationAwareService.prepareReplicationOperation(event);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.beforeMigration(event);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.commitMigration(event);
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.rollbackMigration(event);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
    }

    @Override
    public void reset() {
        Collection<DelegatingWanScheme> publishers = this.getWanReplications().values();
        for (DelegatingWanScheme publisherDelegate : publishers) {
            for (WanPublisher publisher : publisherDelegate.getPublishers()) {
                publisher.reset();
            }
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        Map<String, LocalWanStats> stats = this.getStats();
        if (stats == null) {
            return;
        }
        descriptor.withPrefix("wan");
        for (Map.Entry<String, LocalWanStats> entry : stats.entrySet()) {
            String replicationName = entry.getKey();
            LocalWanStats localWanStats = entry.getValue();
            MetricDescriptor rootDescriptor = descriptor.copy().withDiscriminator("replication", replicationName);
            for (Map.Entry<String, LocalWanPublisherStats> publisherEntry : localWanStats.getLocalWanPublisherStats().entrySet()) {
                String publisherId = publisherEntry.getKey();
                LocalWanPublisherStats wanPublisherStats = publisherEntry.getValue();
                MetricDescriptor publisherDescriptor = rootDescriptor.copy().withTag("publisherId", publisherId);
                context.collect(publisherDescriptor, wanPublisherStats);
                this.provideQueueMetrics(context, publisherDescriptor, replicationName, publisherId);
                this.provideCounterMetrics(context, publisherDescriptor, wanPublisherStats.getSentMapEventCounter(), "map");
                this.provideCounterMetrics(context, publisherDescriptor, wanPublisherStats.getSentCacheEventCounter(), "cache");
                this.provideSyncMetrics(context, wanPublisherStats, publisherDescriptor);
                this.provideConsistencyCheckMetrics(context, wanPublisherStats, publisherDescriptor);
            }
        }
        WanAcknowledger wanAcknowledger = this.acknowledger;
        if (wanAcknowledger instanceof WanThrottlingAcknowledger) {
            WanThrottlingAcknowledger throttlingAcknowledger = (WanThrottlingAcknowledger)wanAcknowledger;
            throttlingAcknowledger.provideMetrics(descriptor.copy(), context);
        }
    }

    private void provideQueueMetrics(MetricsCollectionContext context, MetricDescriptor publisherDescriptor, String replicationName, String publisherId) {
        WanPublisher publisher = this.publisherContainer.getWanReplicationPublishers(replicationName).getPublisher(publisherId);
        if (publisher instanceof AbstractWanPublisher) {
            AbstractWanPublisher eePublisher = (AbstractWanPublisher)publisher;
            int queueCapacity = eePublisher.getConfigurationContext().getPublisherConfig().getQueueCapacity();
            int queueFillRatio = (int)((double)eePublisher.getCurrentElementCount() / (double)queueCapacity * 100.0);
            MetricDescriptor descriptor = publisherDescriptor.copy().withUnit(ProbeUnit.PERCENT).withMetric("queueFillPercent");
            context.collect(descriptor, queueFillRatio);
        }
    }

    private void provideConsistencyCheckMetrics(MetricsCollectionContext context, LocalWanPublisherStats wanPublisherStats, MetricDescriptor publisherDescriptor) {
        Map<String, ConsistencyCheckResult> lastConsistencyCheckResults = wanPublisherStats.getLastConsistencyCheckResults();
        if (lastConsistencyCheckResults != null) {
            for (Map.Entry<String, ConsistencyCheckResult> syncStatsEntry : lastConsistencyCheckResults.entrySet()) {
                String mapName = syncStatsEntry.getKey();
                ConsistencyCheckResult consistencyCheckResult = syncStatsEntry.getValue();
                MetricDescriptor counterDescriptor = publisherDescriptor.copy().withPrefix("wan.consistencyCheck").withTag("map", mapName);
                context.collect(counterDescriptor, consistencyCheckResult);
            }
        }
    }

    private void provideSyncMetrics(MetricsCollectionContext context, LocalWanPublisherStats wanPublisherStats, MetricDescriptor publisherDescriptor) {
        Map<String, WanSyncStats> lastSyncStats = wanPublisherStats.getLastSyncStats();
        if (lastSyncStats != null) {
            for (Map.Entry<String, WanSyncStats> syncStatsEntry : lastSyncStats.entrySet()) {
                String mapName = syncStatsEntry.getKey();
                WanSyncStats syncStats = syncStatsEntry.getValue();
                MetricDescriptor counterDescriptor = publisherDescriptor.copy().withPrefix("wan.sync").withTag("map", mapName);
                context.collect(counterDescriptor, syncStats);
            }
        }
    }

    private void provideCounterMetrics(MetricsCollectionContext context, MetricDescriptor publisherDescriptor, Map<String, WanEventCounters.DistributedObjectWanEventCounters> sentDsEventCounter, String dataStructure) {
        if (sentDsEventCounter == null) {
            return;
        }
        for (Map.Entry<String, WanEventCounters.DistributedObjectWanEventCounters> sentCounterStats : sentDsEventCounter.entrySet()) {
            String dataStructureName = sentCounterStats.getKey();
            WanEventCounters.DistributedObjectWanEventCounters counterStats = sentCounterStats.getValue();
            MetricDescriptor counterDescriptor = publisherDescriptor.copy().withTag(dataStructure, dataStructureName);
            context.collect(counterDescriptor, counterStats);
        }
    }
}

