/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.client.impl.protocol.util.PropertiesUtil;
import com.hazelcast.config.AbstractFactoryWithPropertiesConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class SSLConfig
extends AbstractFactoryWithPropertiesConfig<SSLConfig> {
    private Object factoryImplementation;

    public SSLConfig() {
    }

    public SSLConfig(SSLConfig sslConfig) {
        this.factoryImplementation = sslConfig.factoryImplementation;
        this.setEnabled(sslConfig.isEnabled());
        this.factoryClassName = sslConfig.getFactoryClassName();
        this.setProperties(PropertiesUtil.clone(sslConfig.getProperties()));
    }

    @Override
    public SSLConfig setFactoryClassName(@Nonnull String factoryClassName) {
        super.setFactoryClassName(factoryClassName);
        this.factoryImplementation = null;
        return this;
    }

    public SSLConfig setFactoryImplementation(@Nonnull Object factoryImplementation) {
        this.factoryImplementation = Preconditions.checkNotNull(factoryImplementation, "SSL context factory cannot be null!");
        this.factoryClassName = null;
        return this;
    }

    public Object getFactoryImplementation() {
        return this.factoryImplementation;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.factoryImplementation);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSLConfig other = (SSLConfig)obj;
        return Objects.equals(this.factoryImplementation, other.factoryImplementation);
    }

    @Override
    public String toString() {
        return "SSLConfig [factoryImplementation=" + String.valueOf(this.factoryImplementation) + ", getFactoryClassName()=" + this.getFactoryClassName() + ", isEnabled()=" + this.isEnabled() + ", getProperties()=" + String.valueOf(this.getProperties()) + "]";
    }

    @Override
    protected SSLConfig self() {
        return this;
    }
}

