/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi;

import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.tcp.KeyValuePairGenerator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddCPGroupViewListenerCodec;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.listener.ClientCPGroupViewService;
import com.hazelcast.cluster.Address;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftGroupInfo;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.logging.ILogger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ClientCPGroupViewServiceImpl
implements ClientCPGroupViewService {
    private final HazelcastClientInstanceImpl client;
    private final ClientConnectionManager connectionManager;
    private final ILogger logger;
    private final AtomicReference<Connection> listenerAddedConnection = new AtomicReference();
    private final AtomicLong lastUpdateVersion = new AtomicLong(-1L);
    private final Map<CPGroupId, UUID> lastKnownLeaders = new ConcurrentHashMap<CPGroupId, UUID>();
    private volatile CPGroupId lastKnownMetadataGroupId;

    public ClientCPGroupViewServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientListenerService.class);
        this.connectionManager = client.getConnectionManager();
        this.logger.info("CP operations will be routed directly to group leaders where possible.");
    }

    @Override
    public void start() {
        this.connectionManager.addConnectionListener(this);
    }

    @Override
    @Nullable
    public UUID getLastKnownLeader(CPGroupId groupId) {
        return this.lastKnownLeaders.get(groupId);
    }

    @Override
    @Nullable
    public UUID getLastKnownMetadataLeader() {
        return this.lastKnownMetadataGroupId == null ? null : this.getLastKnownLeader(this.lastKnownMetadataGroupId);
    }

    @Override
    public void setLastKnownLeader(CPGroupId groupId, UUID leaderUuid) {
        this.lastKnownLeaders.put(groupId, leaderUuid);
    }

    @Override
    public Map<CPGroupId, UUID> getAllKnownLeaders() {
        return Collections.unmodifiableMap(this.lastKnownLeaders);
    }

    @Override
    public void initializeKnownLeaders(UUID providerUuid, Address providerAddress, Map<String, String> authResponseKeyValuePairs) {
        String jsonArray = authResponseKeyValuePairs.get("cp.leaders");
        if (jsonArray != null) {
            this.lastKnownLeaders.clear();
            Map<CPGroupId, UUID> cpLeaders = KeyValuePairGenerator.parseJsonForCPMembership(jsonArray);
            this.lastKnownLeaders.putAll(cpLeaders);
            cpLeaders.keySet().forEach(this::setMetadataGroupIfApplicable);
            this.logger.finest("Received initial known CP leaders mapping from %s[%s]: %s", providerUuid, providerAddress, this.lastKnownLeaders);
        }
    }

    public void connectionAdded(Connection connection) {
        this.tryRegister((ClientConnection)connection);
    }

    public void connectionRemoved(Connection connection) {
        this.tryReregisterToRandomConnection(connection);
    }

    private void tryReregisterToRandomConnection(Connection oldConnection) {
        if (!this.listenerAddedConnection.compareAndSet(oldConnection, null)) {
            return;
        }
        ClientConnection newConnection = this.connectionManager.getRandomConnection();
        if (newConnection != null) {
            this.tryRegister(newConnection);
        }
    }

    private void tryRegister(ClientConnection connection) {
        if (!this.listenerAddedConnection.compareAndSet(null, connection)) {
            return;
        }
        ClientMessage clientMessage = ClientAddCPGroupViewListenerCodec.encodeRequest();
        ClientInvocation invocation = new ClientInvocation((HazelcastClientInstance)this.client, clientMessage, null, connection);
        CPGroupViewListenerHandler handler = new CPGroupViewListenerHandler(connection);
        invocation.setEventHandler(handler);
        handler.beforeListenerRegister(connection);
        invocation.invokeUrgent().whenCompleteAsync((message, throwable) -> {
            if (message != null) {
                handler.onListenerRegister(connection);
                return;
            }
            this.tryReregisterToRandomConnection(connection);
        }, ConcurrencyUtil.getDefaultAsyncExecutor());
    }

    @Override
    public boolean isDirectToLeaderEnabled() {
        return true;
    }

    private void setMetadataGroupIfApplicable(CPGroupId groupId) {
        if (groupId.getName().equals("METADATA")) {
            this.lastKnownMetadataGroupId = groupId;
        }
    }

    public final class CPGroupViewListenerHandler
    extends ClientAddCPGroupViewListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ClientConnection connection;

        private CPGroupViewListenerHandler(ClientConnection connection) {
            this.connection = connection;
        }

        @Override
        public void beforeListenerRegister(Connection connection) {
            ClientCPGroupViewServiceImpl.this.logger.finest("Register attempt of CPMembershipViewListenerHandler to %s", connection);
        }

        @Override
        public void onListenerRegister(Connection connection) {
            ClientCPGroupViewServiceImpl.this.logger.finest("Registered CPMembershipViewListenerHandler to %s", connection);
            ClientCPGroupViewServiceImpl.this.lastUpdateVersion.set(-1L);
        }

        @Override
        public void handleGroupsViewEvent(long version, Collection<RaftGroupInfo> groupsInfo, Collection<Map.Entry<UUID, UUID>> cpToApUuids) {
            HashMap cpToApUuidsMap = new HashMap();
            cpToApUuids.forEach(entry -> cpToApUuidsMap.put((UUID)entry.getKey(), (UUID)entry.getValue()));
            ClientCPGroupViewServiceImpl.this.logger.finest("Received CP leaders mapping update from %s[%s]: version: %d, group info: %s, cpToApUuids: %s", this.connection.getRemoteUuid(), this.connection.getRemoteAddress(), version, groupsInfo, cpToApUuidsMap);
            long currentVersion = ClientCPGroupViewServiceImpl.this.lastUpdateVersion.get();
            if (currentVersion < version) {
                HashMap<RaftGroupId, UUID> leaderMap = new HashMap<RaftGroupId, UUID>(groupsInfo.size());
                for (RaftGroupInfo groupInfo : groupsInfo) {
                    UUID apUuid = (UUID)cpToApUuidsMap.get(groupInfo.getLeader().getUuid());
                    if (apUuid == null) continue;
                    leaderMap.put(groupInfo.getGroupId(), apUuid);
                    ClientCPGroupViewServiceImpl.this.setMetadataGroupIfApplicable(groupInfo.getGroupId());
                }
                Set removedIds = ClientCPGroupViewServiceImpl.this.lastKnownLeaders.keySet().stream().filter(id -> !leaderMap.containsKey(id)).collect(Collectors.toSet());
                if (ClientCPGroupViewServiceImpl.this.lastUpdateVersion.compareAndSet(currentVersion, version)) {
                    ClientCPGroupViewServiceImpl.this.lastKnownLeaders.putAll(leaderMap);
                    for (CPGroupId groupId : removedIds) {
                        ClientCPGroupViewServiceImpl.this.lastKnownLeaders.remove(groupId);
                    }
                    ClientCPGroupViewServiceImpl.this.logger.finest("Applied update with version %,d (previous: %,d). Now known leaders: %s", version, currentVersion, ClientCPGroupViewServiceImpl.this.lastKnownLeaders);
                    return;
                }
            }
            ClientCPGroupViewServiceImpl.this.logger.finest("Received update with version: %d but it is behind our version: %d", version, currentVersion);
        }
    }
}

