/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.holder.WanSyncConfigHolder;

public final class WanSyncConfigCodec {
    private static final int CONSISTENCY_CHECK_STRATEGY_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private WanSyncConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, WanSyncConfigHolder wanSyncConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 0, wanSyncConfig.getConsistencyCheckStrategy());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static WanSyncConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        byte consistencyCheckStrategy = FixedSizeTypesCodec.decodeByte(initialFrame.content, 0);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new WanSyncConfigHolder(consistencyCheckStrategy);
    }
}

