/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.internal.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.logging.ILogger;
import java.util.EventListener;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public final class LifecycleServiceImpl
implements LifecycleService {
    private static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<UUID, LifecycleListener> lifecycleListeners = new ConcurrentHashMap<UUID, LifecycleListener>();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final BuildInfo buildInfo;
    private final ExecutorService executor;
    private final Object shutdownMux = new Object();

    public LifecycleServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        this.executor = Executors.newSingleThreadExecutor(new PoolExecutorThreadFactory(client.getName() + ".lifecycle-", classLoader));
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                EventListener implementation = listenerConfig.getImplementation();
                if (implementation == null) {
                    try {
                        implementation = (EventListener)ClassLoaderUtil.newInstance(classLoader, listenerConfig.getClassName());
                    }
                    catch (Exception e) {
                        this.getLogger().severe(e);
                    }
                }
                if (!(implementation instanceof LifecycleListener)) continue;
                LifecycleListener listener = (LifecycleListener)implementation;
                this.addLifecycleListener(listener);
            }
        }
        this.buildInfo = BuildInfoProvider.getBuildInfo();
    }

    private ILogger getLogger() {
        return this.client.getLoggingService().getLogger(LifecycleService.class);
    }

    @Override
    @Nonnull
    public UUID addLifecycleListener(@Nonnull LifecycleListener lifecycleListener) {
        Preconditions.checkNotNull(lifecycleListener, "lifecycleListener must not be null");
        UUID id = UuidUtil.newUnsecureUUID();
        this.lifecycleListeners.put(id, lifecycleListener);
        return id;
    }

    @Override
    public boolean removeLifecycleListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId must not be null");
        return this.lifecycleListeners.remove(registrationId) != null;
    }

    public void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        LifecycleEvent lifecycleEvent = new LifecycleEvent(lifecycleState);
        Object revision = this.buildInfo.getRevision();
        if (StringUtil.isNullOrEmpty((String)revision)) {
            revision = "";
        } else {
            String upstreamRevision;
            revision = " - " + (String)revision;
            BuildInfo upstreamInfo = this.buildInfo.getUpstreamBuildInfo();
            if (upstreamInfo != null && !StringUtil.isNullOrEmpty(upstreamRevision = upstreamInfo.getRevision())) {
                revision = (String)revision + ", " + upstreamRevision;
            }
        }
        this.getLogger().info("HazelcastClient " + this.buildInfo.getVersion() + " (" + this.buildInfo.getBuild() + (String)revision + ") is " + String.valueOf((Object)lifecycleEvent.getState()));
        this.executor.execute(() -> {
            for (LifecycleListener lifecycleListener : this.lifecycleListeners.values()) {
                lifecycleListener.stateChanged(lifecycleEvent);
            }
        });
    }

    @Override
    public boolean isRunning() {
        return this.active.get();
    }

    @Override
    public void shutdown() {
        this.client.onGracefulShutdown();
        this.doShutdown();
    }

    @Override
    public void terminate() {
        this.doShutdown();
    }

    public void start() {
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
        this.active.set(true);
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() {
        Object object = this.shutdownMux;
        synchronized (object) {
            if (!this.active.compareAndSet(true, false)) {
                return;
            }
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            HazelcastClient.shutdown(this.client.getName());
            this.client.doShutdown();
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
            this.shutdownExecutor();
        }
    }

    private void shutdownExecutor() {
        this.executor.shutdown();
        try {
            boolean success = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                this.getLogger().warning("LifecycleService executor awaitTermination could not completed gracefully in 30 seconds. Terminating forcefully.");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLogger().warning("LifecycleService executor awaitTermination is interrupted. Terminating forcefully.", e);
            this.executor.shutdownNow();
        }
    }
}

