/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.impl.DelegatingCompletableFuture;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClientDelegatingFuture<V>
extends DelegatingCompletableFuture<V> {
    private static final AtomicReferenceFieldUpdater<ClientDelegatingFuture, Object> DECODED_RESPONSE = AtomicReferenceFieldUpdater.newUpdater(ClientDelegatingFuture.class, Object.class, "decodedResponse");
    final boolean deserializeResponse;
    private final ClientMessageDecoder clientMessageDecoder;
    private volatile Object decodedResponse = VOID;

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, V defaultValue, boolean deserializeResponse) {
        super(serializationService, clientInvocationFuture, defaultValue, false);
        this.clientMessageDecoder = clientMessageDecoder;
        this.deserializeResponse = deserializeResponse;
        this.future.whenCompleteAsync((T v, U t) -> this.completeSuper(v, (Throwable)t), ConcurrencyUtil.CALLER_RUNS);
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, V defaultValue) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, defaultValue, true);
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, null, true);
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, boolean deserializeResponse) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, null, deserializeResponse);
    }

    @Override
    public V getNow(V valueIfAbsent) {
        if (this.result != null) {
            return (V)this.result;
        }
        if (this.deserializedValue != VOID) {
            return (V)this.deserializedValue;
        }
        V value = this.future.getNow(valueIfAbsent);
        try {
            if (value instanceof ClientMessage) {
                return this.resolve(value);
            }
            return (V)(value instanceof Data && this.deserializeResponse ? this.serializationService.toObject(value) : value);
        }
        catch (HazelcastSerializationException exc) {
            throw new CompletionException(exc);
        }
    }

    @Override
    protected V resolve(Object object) {
        if (this.result != null) {
            return (V)this.result;
        }
        if (this.deserializedValue != VOID) {
            return (V)this.deserializedValue;
        }
        ClientMessage clientMessage = (ClientMessage)object;
        Object decoded = this.decodeResponse(clientMessage);
        if (this.deserializeResponse) {
            decoded = this.serializationService.toObject(decoded);
        }
        decoded = this.cacheDeserializedValue(decoded);
        return (V)decoded;
    }

    private Object resolveAny(Object o) {
        if (o instanceof ClientMessage) {
            return this.resolve(o);
        }
        if (this.deserializeResponse) {
            return this.serializationService.toObject(o);
        }
        return o;
    }

    private Object decodeResponse(ClientMessage clientMessage) {
        if (this.decodedResponse != VOID) {
            return this.decodedResponse;
        }
        Object newDecodedResponse = this.clientMessageDecoder.decodeClientMessage(clientMessage);
        DECODED_RESPONSE.compareAndSet(this, VOID, newDecodedResponse);
        return newDecodedResponse;
    }

    protected ClientInvocationFuture getFuture() {
        return (ClientInvocationFuture)this.future;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super V, ? extends U> fn) {
        return this.future.thenApplyAsync(new DeserializingFunction<U>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return this.future.thenApplyAsync(new DeserializingFunction<U>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        return this.future.thenApplyAsync(new DeserializingFunction<U>(fn), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super V> action) {
        return this.future.thenAcceptAsync((Consumer)new DeserializingConsumer(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action) {
        return this.future.thenAcceptAsync((Consumer)new DeserializingConsumer(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        return this.future.thenAcceptAsync((Consumer)new DeserializingConsumer(action), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.future.thenRunAsync(new DeserializingRunnable(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.future.thenRunAsync(new DeserializingRunnable(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.future.thenRunAsync(new DeserializingRunnable(action), executor);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<U, V1>(fn), this.defaultExecutor());
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<U, V1>(fn), this.defaultExecutor());
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<U, V1>(fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<U>(action), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<U>(action), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<U>(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterBothAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return ClientDelegatingFuture.applyToEitherAsync(this.future, other, new DeserializingFunction<U>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return ClientDelegatingFuture.applyToEitherAsync(this.future, other, new DeserializingFunction<U>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn, Executor executor) {
        return ClientDelegatingFuture.applyToEitherAsync(this.future, other, new DeserializingFunction<U>(fn), executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return ClientDelegatingFuture.acceptEitherAsync(this.future, other, new DeserializingConsumer(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return ClientDelegatingFuture.acceptEitherAsync(this.future, other, new DeserializingConsumer(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action, Executor executor) {
        return ClientDelegatingFuture.acceptEitherAsync(this.future, other, new DeserializingConsumer(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterEitherAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenComposeAsync(new DeserializingFunction<CompletionStage<U>>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenComposeAsync(new DeserializingFunction<CompletionStage<U>>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.future.thenComposeAsync(new DeserializingFunction<CompletionStage<U>>(fn), executor);
    }

    @Override
    public CompletableFuture<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        return this.future.handleAsync((BiFunction)new WhenCompleteAdapter(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        return this.future.handleAsync((BiFunction)new WhenCompleteAdapter(action), this.defaultExecutor());
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        return this.future.handleAsync((BiFunction)new WhenCompleteAdapter(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handleAsync(new HandleBiFunction<U>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handleAsync(new HandleBiFunction<U>(fn), this.defaultExecutor());
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        return this.future.handleAsync(new HandleBiFunction<U>(fn), executor);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<V> exceptionally(Function<Throwable, ? extends V> fn) {
        return this.future.handleAsync((BiFunction)new ExceptionallyAdapter(fn), this.defaultExecutor());
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public void obtrudeValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void obtrudeException(Throwable ex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfDependents() {
        return this.future.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return "ClientDelegatingFuture{future=" + this.future.toString() + "}";
    }

    private static CompletableFuture<Void> acceptEitherAsync(CompletableFuture stage, CompletionStage other, Consumer action, Executor executor) {
        return stage.acceptEitherAsync(other, action, executor);
    }

    private static CompletableFuture applyToEitherAsync(CompletableFuture stage, CompletionStage other, Function fn, Executor executor) {
        return stage.applyToEitherAsync(other, fn, executor);
    }

    class DeserializingFunction<R>
    implements Function<ClientMessage, R> {
        private final Function<? super V, ? extends R> delegate;

        DeserializingFunction(Function<? super V, ? extends R> delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public R apply(ClientMessage e) {
            return this.delegate.apply(ClientDelegatingFuture.this.resolve(e));
        }
    }

    class DeserializingConsumer
    implements Consumer<ClientMessage> {
        private final Consumer<? super V> delegate;

        DeserializingConsumer(Consumer<? super V> delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public void accept(ClientMessage e) {
            Object resolved = ClientDelegatingFuture.this.resolve(e);
            this.delegate.accept(resolved);
        }

        public String toString() {
            return "DeserializingConsumer{delegate=" + String.valueOf(this.delegate) + "}";
        }
    }

    class DeserializingRunnable
    implements Runnable {
        private final Runnable delegate;

        DeserializingRunnable(Runnable delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public void run() {
            ClientDelegatingFuture.this.resolve(ClientDelegatingFuture.this.future.join());
            this.delegate.run();
        }
    }

    class DeserializingBiFunction<U, R>
    implements BiFunction<ClientMessage, U, R> {
        private final BiFunction<? super V, U, ? extends R> delegate;

        DeserializingBiFunction(BiFunction<? super V, U, ? extends R> delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public R apply(ClientMessage t, U u) {
            Object resolved = t == null ? null : (Object)ClientDelegatingFuture.this.resolve(t);
            return this.delegate.apply(resolved, ClientDelegatingFuture.this.resolveAny(u));
        }
    }

    class DeserializingBiConsumer<U>
    implements BiConsumer<ClientMessage, U> {
        private final BiConsumer<? super V, U> delegate;

        DeserializingBiConsumer(BiConsumer<? super V, U> delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public void accept(ClientMessage t, U u) {
            Object resolved = t == null ? null : (Object)ClientDelegatingFuture.this.resolve(t);
            this.delegate.accept(resolved, ClientDelegatingFuture.this.resolveAny(u));
        }
    }

    class WhenCompleteAdapter
    implements BiFunction<ClientMessage, Throwable, V> {
        private final BiConsumer<? super V, ? super Throwable> delegate;

        WhenCompleteAdapter(BiConsumer<? super V, ? super Throwable> delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public V apply(ClientMessage message, Throwable t) {
            Object resolved = null;
            Throwable delegateException = null;
            try {
                resolved = message == null ? null : (Object)ClientDelegatingFuture.this.resolve(message);
            }
            catch (HazelcastSerializationException exc) {
                t = exc;
            }
            try {
                this.delegate.accept(resolved, t);
            }
            catch (Throwable throwable) {
                delegateException = throwable;
            }
            if (t != null) {
                if (t instanceof CancellationException) {
                    throw new CompletionException(t);
                }
                throw ExceptionUtil.sneakyThrow(t);
            }
            if (delegateException != null) {
                throw ExceptionUtil.sneakyThrow(delegateException);
            }
            return resolved;
        }
    }

    class HandleBiFunction<R>
    implements BiFunction<ClientMessage, Throwable, R> {
        private final BiFunction<? super V, Throwable, R> delegate;

        HandleBiFunction(BiFunction<? super V, Throwable, R> delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public R apply(ClientMessage t, Throwable u) {
            Object resolved = null;
            try {
                resolved = t == null ? null : (Object)ClientDelegatingFuture.this.resolve(t);
            }
            catch (HazelcastSerializationException exc) {
                u = exc;
            }
            return this.delegate.apply(resolved, u);
        }
    }

    class ExceptionallyAdapter
    implements BiFunction<ClientMessage, Throwable, V> {
        private final Function<? super Throwable, ? extends V> delegate;

        ExceptionallyAdapter(Function<? super Throwable, ? extends V> delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public V apply(ClientMessage message, Throwable t) {
            if (t != null) {
                return this.delegate.apply(t);
            }
            try {
                Object resolved = message == null ? null : (Object)ClientDelegatingFuture.this.resolve(message);
                return resolved;
            }
            catch (HazelcastSerializationException throwable) {
                return this.delegate.apply(throwable);
            }
        }
    }
}

