/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.cpmap;

import com.hazelcast.client.cp.internal.datastructures.CPClientProxy;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.protocol.codec.CPMapCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPMapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.CPMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.CPMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.CPMapPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.CPMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CPMapSetCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cp.CPMap;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.Preconditions;
import javax.annotation.Nonnull;

public class CPMapProxy<K, V>
extends CPClientProxy
implements CPMap<K, V> {
    public CPMapProxy(ClientContext context, String proxyName, String objectName, RaftGroupId groupId) {
        super("hz:raft:mapService", proxyName, context, groupId, objectName);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        return this.keyValueRequest(KeyValueOp.PUT, key, value);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        return this.keyValueRequest(KeyValueOp.PUT_IF_ABSENT, key, value);
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value) {
        this.keyValueRequest(KeyValueOp.SET, key, value);
    }

    @Override
    public V remove(@Nonnull K key) {
        return this.removeRequest(key);
    }

    @Override
    public void delete(@Nonnull K key) {
        this.deleteRequest(key);
    }

    @Override
    public boolean compareAndSet(@Nonnull K key, @Nonnull V expectedValue, @Nonnull V newValue) {
        Preconditions.checkNotNull(key, "argument 'key' cannot be null");
        Preconditions.checkNotNull(expectedValue, "argument 'expectedValue' cannot be null");
        Preconditions.checkNotNull(newValue, "argument 'newValue' cannot be null");
        InternalSerializationService serializationService = this.getContext().getSerializationService();
        Object dataKey = serializationService.toData(key);
        Object dataExpectedValue = serializationService.toData(expectedValue);
        Object dataNewValue = serializationService.toData(newValue);
        ClientMessage request = CPMapCompareAndSetCodec.encodeRequest(this.groupId, this.objectName, dataKey, dataExpectedValue, dataNewValue);
        ClientInvocationFuture f = this.invokeClientRequest(request, this.name);
        return (Boolean)new ClientDelegatingFuture(f, this.getSerializationService(), CPMapCompareAndSetCodec::decodeResponse).joinInternal();
    }

    @Override
    public V get(@Nonnull K key) {
        return this.getRequest(key);
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        this.invokeClientRequest(request, this.name).joinInternal();
    }

    private V keyValueRequest(KeyValueOp keyValueOp, K key, V value) {
        Preconditions.checkNotNull(key, "argument 'key' cannot be null");
        Preconditions.checkNotNull(value, "argument 'value' cannot be null");
        InternalSerializationService serializationService = this.getContext().getSerializationService();
        Object dataKey = serializationService.toData(key);
        Object dataValue = serializationService.toData(value);
        ClientMessage request = this.createKeyValueClientMessage(keyValueOp, (Data)dataKey, (Data)dataValue);
        ClientInvocationFuture f = this.invokeClientRequest(request, this.name);
        if (KeyValueOp.SET == keyValueOp) {
            f.joinInternal();
            return null;
        }
        return new ClientDelegatingFuture(f, this.getSerializationService(), KeyValueOp.PUT == keyValueOp ? CPMapPutCodec::decodeResponse : CPMapPutIfAbsentCodec::decodeResponse).joinInternal();
    }

    private ClientMessage createKeyValueClientMessage(KeyValueOp keyValueOp, Data key, Data value) {
        return switch (keyValueOp) {
            case KeyValueOp.SET -> CPMapSetCodec.encodeRequest(this.groupId, this.objectName, key, value);
            case KeyValueOp.PUT -> CPMapPutCodec.encodeRequest(this.groupId, this.objectName, key, value);
            case KeyValueOp.PUT_IF_ABSENT -> CPMapPutIfAbsentCodec.encodeRequest(this.groupId, this.objectName, key, value);
            default -> throw new IllegalArgumentException("Unknown op: " + String.valueOf((Object)keyValueOp));
        };
    }

    private V getRequest(K key) {
        return this.keyRequest(key, KeyOp.GET);
    }

    private V removeRequest(K key) {
        return this.keyRequest(key, KeyOp.REMOVE);
    }

    private void deleteRequest(K key) {
        this.keyRequest(key, KeyOp.DELETE);
    }

    private V keyRequest(K key, KeyOp keyOp) {
        Preconditions.checkNotNull(key, "argument 'key' cannot be null");
        Object dataKey = this.getContext().getSerializationService().toData(key);
        ClientMessage request = this.getKeyClientMessage(keyOp, (Data)dataKey);
        ClientInvocationFuture clientInvocationFuture = this.invokeClientRequest(request, this.name);
        if (KeyOp.DELETE == keyOp) {
            clientInvocationFuture.joinInternal();
            return null;
        }
        ClientDelegatingFuture clientDelegatingFuture = new ClientDelegatingFuture(clientInvocationFuture, this.getSerializationService(), keyOp == KeyOp.GET ? CPMapGetCodec::decodeResponse : CPMapRemoveCodec::decodeResponse);
        return clientDelegatingFuture.joinInternal();
    }

    private ClientMessage getKeyClientMessage(KeyOp keyOp, Data key) {
        switch (keyOp) {
            case GET: {
                return CPMapGetCodec.encodeRequest(this.groupId, this.objectName, key);
            }
            case REMOVE: {
                return CPMapRemoveCodec.encodeRequest(this.groupId, this.objectName, key);
            }
            case DELETE: {
                return CPMapDeleteCodec.encodeRequest(this.groupId, this.objectName, key);
            }
        }
        throw new IllegalArgumentException("Unknown op: " + String.valueOf((Object)keyOp));
    }

    public RaftGroupId getGroupId() {
        return this.groupId;
    }

    private static enum KeyValueOp {
        PUT,
        PUT_IF_ABSENT,
        SET;

    }

    private static enum KeyOp {
        GET,
        REMOVE,
        DELETE;

    }
}

