/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class CacheSegmentShutdownOperation
extends Operation
implements PartitionAwareOperation,
AllowedDuringPassiveState,
IdentifiedDataSerializable {
    private final CountDownLatch done = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int partitionId = this.getPartitionId();
            EnterpriseCacheService service = (EnterpriseCacheService)this.getService();
            CachePartitionSegment segment = service.getSegment(partitionId);
            segment.shutdown();
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        this.done.countDown();
        super.onExecutionFailure(e);
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.done.await(timeout, unit);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFactoryId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getClassId() {
        throw new UnsupportedOperationException();
    }
}

