/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.CacheMergeOperation;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CacheMergeOperationFactory
extends PartitionAwareOperationFactory {
    private String name;
    private List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>>[] mergingEntries;
    private SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> policy;

    public CacheMergeOperationFactory() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public CacheMergeOperationFactory(String name, int[] partitions, List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>>[] mergingEntries, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> policy) {
        this.name = name;
        this.partitions = partitions;
        this.mergingEntries = mergingEntries;
        this.policy = policy;
    }

    @Override
    public Operation createPartitionOperation(int partitionId) {
        for (int i = 0; i < this.partitions.length; ++i) {
            if (this.partitions[i] != partitionId) continue;
            return new CacheMergeOperation(this.name, this.mergingEntries[i], this.policy);
        }
        throw new IllegalArgumentException("Unknown partitionId " + partitionId + " (" + Arrays.toString(this.partitions) + ")");
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeIntArray(this.partitions);
        for (List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> list : this.mergingEntries) {
            out.writeInt(list.size());
            for (SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry : list) {
                out.writeObject(mergingEntry);
            }
        }
        out.writeObject(this.policy);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.partitions = in.readIntArray();
        this.mergingEntries = new List[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            int size = in.readInt();
            ArrayList<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> list = new ArrayList<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>>(size);
            for (int j = 0; j < size; ++j) {
                SplitBrainMergeTypes.CacheMergeTypes mergingEntry = (SplitBrainMergeTypes.CacheMergeTypes)in.readObject();
                list.add(mergingEntry);
            }
            this.mergingEntries[i] = list;
        }
        this.policy = (SplitBrainMergePolicy)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 26;
    }
}

