/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecord;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecordStore;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import javax.cache.expiry.ExpiryPolicy;

public class HiDensityNativeMemoryCacheEntryProcessorEntry<K, V>
extends CacheEntryProcessorEntry<K, V, HiDensityNativeMemoryCacheRecord> {
    private final HiDensityRecordProcessor cacheRecordProcessor;

    public HiDensityNativeMemoryCacheEntryProcessorEntry(Data keyData, HiDensityNativeMemoryCacheRecord record, HiDensityNativeMemoryCacheRecordStore cacheRecordStore, long now, int completionId) {
        super(keyData, record, cacheRecordStore, now, completionId);
        this.cacheRecordProcessor = cacheRecordStore.getRecordProcessor();
    }

    @Override
    protected V getRecordValue(HiDensityNativeMemoryCacheRecord record) {
        return (V)((HiDensityNativeMemoryCacheRecordStore)this.cacheRecordStore).getRecordValue(record);
    }

    @Override
    public void applyChanges() {
        Data data;
        super.applyChanges();
        if (this.state != CacheEntryProcessorEntry.State.CREATE && this.state != CacheEntryProcessorEntry.State.LOAD && (data = this.keyData) instanceof NativeMemoryData) {
            NativeMemoryData data2 = (NativeMemoryData)data;
            this.cacheRecordProcessor.addDeferredDispose(data2);
        }
    }

    @Override
    protected void onCreate(Data key, Object value, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId, boolean saved) {
        if (key instanceof NativeMemoryData) {
            NativeMemoryData data = (NativeMemoryData)key;
            if (saved) {
                long size = this.cacheRecordProcessor.getSize(data);
                this.cacheRecordProcessor.increaseUsedMemory(size);
            } else {
                this.cacheRecordProcessor.addDeferredDispose(data);
            }
        }
    }

    @Override
    protected void onLoad(Data key, Object value, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId, boolean saved) {
        if (key instanceof NativeMemoryData) {
            NativeMemoryData data = (NativeMemoryData)key;
            if (saved) {
                long size = this.cacheRecordProcessor.getSize(data);
                this.cacheRecordProcessor.increaseUsedMemory(size);
            } else {
                this.cacheRecordProcessor.addDeferredDispose(data);
            }
        }
    }
}

