/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheEventType;
import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEventContext;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.EnterpriseCachePartitionSegment;
import com.hazelcast.cache.impl.EnterpriseCacheRecordStore;
import com.hazelcast.cache.impl.EnterpriseCacheServiceExtension;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.PreJoinCacheConfig;
import com.hazelcast.cache.impl.event.CacheWanEventPublisher;
import com.hazelcast.cache.impl.event.CacheWanEventPublisherImpl;
import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.HiDensityCacheStorageInfo;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.nativememory.HotRestartHiDensityNativeMemoryCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.CacheSegmentShutdownOperation;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheOperationProvider;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheReplicationOperation;
import com.hazelcast.cache.impl.hotrestart.HotRestartEnterpriseCacheRecordStore;
import com.hazelcast.cache.impl.merge.entry.LazyCacheEntryView;
import com.hazelcast.cache.impl.operation.CacheMerkleTreePartitionCompareOperation;
import com.hazelcast.cache.impl.operation.CacheReplicationOperation;
import com.hazelcast.cache.impl.operation.CacheSegmentDestroyOperation;
import com.hazelcast.cache.impl.operation.EnterpriseCacheOperationProvider;
import com.hazelcast.cache.impl.operation.EnterpriseCacheReplicationOperation;
import com.hazelcast.cache.impl.wan.CacheFilterProvider;
import com.hazelcast.cache.impl.wan.WanCacheEntryView;
import com.hazelcast.cache.impl.wan.WanCacheSupportingService;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheAddOrUpdateEvent;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheRemoveEvent;
import com.hazelcast.cache.wan.CacheWanEventFilter;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.enterprise.wan.WanFilterEventType;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.PersistentConfigDescriptors;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.ChunkSuppliers;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.impl.MerkleTreePartitionComparisonOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.LocalRetryableExecution;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.wan.impl.DelegatingWanScheme;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnterpriseCacheService
extends CacheService
implements EnterpriseCacheServiceExtension,
WanSupportingService,
RamStoreRegistry,
OffloadedReplicationPreparation {
    private static final int CACHE_SEGMENT_DESTROY_OPERATION_AWAIT_TIME_IN_SECS = 30;
    private final ConcurrentMap<String, DelegatingWanScheme> wanReplicationDelegates = new ConcurrentHashMap<String, DelegatingWanScheme>();
    private final ConcurrentMap<String, String> wanMergePolicies = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, HiDensityStorageInfo> hiDensityCacheInfoMap = new ConcurrentHashMap<String, HiDensityStorageInfo>();
    private final ConstructorFunction<String, HiDensityStorageInfo> hiDensityCacheInfoConstructorFunction = cacheNameWithPrefix -> {
        CacheConfig cacheConfig = this.getCacheConfig((String)cacheNameWithPrefix);
        if (cacheConfig == null) {
            throw new CacheNotExistsException("Cache " + cacheNameWithPrefix + " is already destroyed or not created yet, on " + String.valueOf(this.nodeEngine.getLocalMember()));
        }
        CacheContext cacheContext = this.getOrCreateCacheContext((String)cacheNameWithPrefix);
        return new HiDensityCacheStorageInfo((String)cacheNameWithPrefix, cacheContext);
    };
    private IPartitionService partitionService;
    private CacheFilterProvider cacheFilterProvider;
    private CacheWanEventPublisher cacheWanEventPublisher;
    private HotRestartIntegrationService hotRestartService;
    private WanSupportingService wanSupportingService;

    @Override
    protected void postInit(NodeEngine nodeEngine, Properties properties, boolean metricsEnabled) {
        super.postInit(nodeEngine, properties, metricsEnabled);
        this.wanSupportingService = new WanCacheSupportingService(this);
        this.cacheFilterProvider = new CacheFilterProvider(nodeEngine);
        this.cacheWanEventPublisher = new CacheWanEventPublisherImpl(this);
        this.partitionService = nodeEngine.getPartitionService();
        this.hotRestartService = this.getHotRestartService();
        if (this.hotRestartService != null) {
            this.hotRestartService.registerRamStoreRegistry("hz:impl:cacheService", this);
            this.hotRestartService.registerLoadedConfigurationListener((serviceName, name, config) -> {
                if ("hz:impl:cacheService".equals(serviceName)) {
                    if (config instanceof CacheConfig) {
                        CacheConfig cacheConfig = (CacheConfig)config;
                        this.putCacheConfigIfAbsent(cacheConfig);
                    } else {
                        this.logger.warning("Configuration " + String.valueOf(config) + " has an unknown type " + String.valueOf(config.getClass()));
                    }
                }
            });
        }
        if (metricsEnabled) {
            nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(new HDStorageInfoMetricsProvider(this.hiDensityCacheInfoMap));
        }
    }

    @Override
    protected CachePartitionSegment newPartitionSegment(int partitionId) {
        return new EnterpriseCachePartitionSegment(this, partitionId);
    }

    @Override
    public RamStore ramStoreForPrefix(long prefix) {
        String name = this.hotRestartService.getCacheName(prefix);
        return (RamStore)((Object)this.getRecordStore(name, PersistentConfigDescriptors.toPartitionId(prefix)));
    }

    @Override
    public RamStore restartingRamStoreForPrefix(long prefix) {
        String name = this.hotRestartService.getCacheName(prefix);
        return (RamStore)((Object)this.getOrCreateRecordStore(name, PersistentConfigDescriptors.toPartitionId(prefix)));
    }

    @Override
    public int prefixToThreadId(long prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BiTuple<String, String> describe(long prefix) {
        return BiTuple.of("Cache " + this.hotRestartService.getCacheName(prefix), "set data persistence enabled in CacheConfig#dataPersistenceConfig or CacheSimpleConfig#dataPersistenceConfig");
    }

    public HotRestartStore onHeapHotRestartStoreForPartition(int partitionId) {
        return this.hotRestartService.getOnHeapHotRestartStoreForPartition(partitionId);
    }

    public HotRestartStore offHeapHotRestartStoreForPartition(int partitionId) {
        return this.hotRestartService.getOffHeapHotRestartStoreForPartition(partitionId);
    }

    @Nonnull
    public Collection<String> getAllCacheNamesWithPrefix() {
        return this.cacheContexts.keySet();
    }

    @Override
    public boolean shouldEnableMerkleTree(String cacheName, boolean log) {
        boolean implicitlyEnabled;
        CacheConfig cacheConfig = this.getCacheConfig(cacheName);
        if (cacheConfig == null) {
            return false;
        }
        CacheContext cacheContext = this.getOrCreateCacheContext(cacheName);
        boolean bl = implicitlyEnabled = cacheConfig.getHotRestartConfig().isEnabled() && cacheConfig.getMerkleTreeConfig().getEnabled() == null;
        if (implicitlyEnabled && log && cacheContext.shouldLogImplicitMerkleTreeEnable()) {
            this.logger.info("Enabling MerkleTreeConfig for cache \"" + cacheName + "\", as it enhances member recovery performance. Consider enabling MerkleTreeConfig explicitly in your configuration.");
        }
        return Boolean.TRUE.equals(cacheConfig.getMerkleTreeConfig().getEnabled()) || implicitlyEnabled;
    }

    @Override
    protected ICacheRecordStore createNewRecordStore(String cacheNameWithPrefix, int partitionId) {
        CacheConfig cacheConfig = this.getCacheConfig(cacheNameWithPrefix);
        if (cacheConfig == null) {
            throw new CacheNotExistsException("Cache is already destroyed or not created yet, on " + String.valueOf(this.nodeEngine.getLocalMember()));
        }
        InMemoryFormat inMemoryFormat = cacheConfig.getInMemoryFormat();
        boolean isNative = switch (inMemoryFormat) {
            case InMemoryFormat.NATIVE -> true;
            case InMemoryFormat.BINARY, InMemoryFormat.OBJECT -> false;
            default -> throw new IllegalArgumentException("Cannot create record store for the storage type: " + String.valueOf((Object)inMemoryFormat));
        };
        long prefix = 0L;
        HotRestartConfig hotRestartConfig = EnterpriseCacheService.getHotRestartConfig(cacheConfig);
        if (hotRestartConfig.isEnabled()) {
            if (this.hotRestartService == null) {
                throw new HazelcastException("Hot Restart is enabled for cache: " + cacheConfig.getName() + " but Hot Restart persistence is not enabled!");
            }
            this.hotRestartService.ensureHasConfiguration("hz:impl:cacheService", cacheNameWithPrefix, new PreJoinCacheConfig(cacheConfig, false));
            prefix = this.hotRestartService.registerRamStore(this, "hz:impl:cacheService", cacheNameWithPrefix, partitionId);
            if (!this.hotRestartService.isStartCompleted()) {
                UUID source = this.nodeEngine.getLocalMember().getUuid();
                this.nodeEngine.getProxyService().initializeDistributedObject("hz:impl:cacheService", cacheNameWithPrefix, source);
            }
        }
        return isNative ? this.newNativeRecordStore(cacheNameWithPrefix, partitionId, hotRestartConfig, prefix) : this.newHeapRecordStore(cacheNameWithPrefix, partitionId, hotRestartConfig, prefix);
    }

    private static HotRestartConfig getHotRestartConfig(CacheConfig cacheConfig) {
        return cacheConfig.getHotRestartConfig();
    }

    private HotRestartIntegrationService getHotRestartService() {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.nodeEngine.getNode().getNodeExtension();
        return nodeExtension.isHotRestartEnabled() ? (HotRestartIntegrationService)nodeExtension.getInternalHotRestartService() : null;
    }

    private ICacheRecordStore newHeapRecordStore(String name, int partitionId, HotRestartConfig hotRestart, long prefix) {
        return hotRestart.isEnabled() ? new HotRestartEnterpriseCacheRecordStore(name, partitionId, this.nodeEngine, this, hotRestart.isFsync(), prefix) : new EnterpriseCacheRecordStore(name, partitionId, this.nodeEngine, this);
    }

    private ICacheRecordStore newNativeRecordStore(String cacheNameWithPrefix, int partitionId, HotRestartConfig hotRestart, long prefix) {
        try {
            return hotRestart.isEnabled() ? new HotRestartHiDensityNativeMemoryCacheRecordStore(partitionId, cacheNameWithPrefix, this, this.nodeEngine, hotRestart.isFsync(), prefix) : new HiDensityNativeMemoryCacheRecordStore(partitionId, cacheNameWithPrefix, this, this.nodeEngine);
        }
        catch (NativeOutOfMemoryError e) {
            throw new NativeOutOfMemoryError("Cannot create internal cache map, not enough contiguous memory available! -> " + e.getMessage(), e);
        }
    }

    @Override
    protected void destroySegments(CacheConfig cacheConfig) {
        if (cacheConfig.getInMemoryFormat() != InMemoryFormat.NATIVE) {
            super.destroySegments(cacheConfig);
            return;
        }
        String cacheNameWithPrefix = cacheConfig.getNameWithPrefix();
        this.destroySegmentsInternal(cacheNameWithPrefix);
        this.hiDensityCacheInfoMap.remove(cacheNameWithPrefix);
    }

    private void destroySegmentsInternal(String cacheNameWithPrefix) {
        OperationService operationService = this.nodeEngine.getOperationService();
        ArrayList<LocalRetryableExecution> executions = new ArrayList<LocalRetryableExecution>();
        for (CachePartitionSegment segment : this.segments) {
            if (!segment.hasRecordStore(cacheNameWithPrefix)) continue;
            CacheSegmentDestroyOperation op = new CacheSegmentDestroyOperation(cacheNameWithPrefix);
            op.setPartitionId(segment.getPartitionId());
            op.setNodeEngine(this.nodeEngine).setService(this);
            if (operationService.isRunAllowed(op)) {
                operationService.run(op);
                continue;
            }
            executions.add(InvocationUtil.executeLocallyWithRetry(this.nodeEngine, op));
        }
        for (LocalRetryableExecution execution : executions) {
            try {
                if (execution.awaitCompletion(30L, TimeUnit.SECONDS)) continue;
                this.logger.warning("Cache segment was not destroyed in expected time, possible leak");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.nodeEngine.getLogger(this.getClass()).warning(e);
            }
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        OperationService operationService = this.nodeEngine.getOperationService();
        ArrayList<CacheSegmentShutdownOperation> ops = new ArrayList<CacheSegmentShutdownOperation>();
        for (CachePartitionSegment segment : this.segments) {
            if (!segment.hasAnyRecordStore()) continue;
            CacheSegmentShutdownOperation op = new CacheSegmentShutdownOperation();
            op.setPartitionId(segment.getPartitionId());
            op.setNodeEngine(this.nodeEngine).setService(this);
            if (operationService.isRunAllowed(op)) {
                operationService.run(op);
                continue;
            }
            operationService.execute(op);
            ops.add(op);
        }
        for (CacheSegmentShutdownOperation op : ops) {
            try {
                op.awaitCompletion(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.nodeEngine.getLogger(this.getClass()).warning(e);
            }
        }
        this.hiDensityCacheInfoMap.clear();
    }

    @Override
    public void reset() {
        this.shutdown(false);
    }

    @Override
    public int forceEvict(String name, int originalPartitionId) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Forced eviction " + name + ", original partition ID: " + originalPartitionId);
        }
        int evicted = 0;
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        int threadCount = this.getPartitionThreadCount();
        int mod = originalPartitionId % threadCount;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            ICacheRecordStore cache;
            if (partitionId % threadCount != mod || !((cache = this.getRecordStore(name, partitionId)) instanceof HiDensityCacheRecordStore)) continue;
            HiDensityCacheRecordStore store = (HiDensityCacheRecordStore)cache;
            evicted += store.forceEvict();
        }
        return evicted;
    }

    private int getPartitionThreadCount() {
        return this.nodeEngine.getOperationService().getPartitionThreadCount();
    }

    @Override
    public int forceEvictOnOthers(String name, int originalPartitionId) {
        int evicted = 0;
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        int threadCount = this.getPartitionThreadCount();
        int mod = originalPartitionId % threadCount;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            if (partitionId % threadCount != mod) continue;
            for (CacheConfig cacheConfig : this.getCacheConfigs()) {
                ICacheRecordStore cache;
                String cacheName = cacheConfig.getNameWithPrefix();
                if (cacheName.equals(name) || !((cache = this.getRecordStore(cacheName, partitionId)) instanceof HiDensityCacheRecordStore)) continue;
                HiDensityCacheRecordStore store = (HiDensityCacheRecordStore)cache;
                evicted += store.forceEvict();
            }
        }
        return evicted;
    }

    @Override
    public void clearAll(int originalPartitionId) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        int threadCount = this.getPartitionThreadCount();
        int mod = originalPartitionId % threadCount;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            if (partitionId % threadCount != mod) continue;
            for (CacheConfig cacheConfig : this.getCacheConfigs()) {
                String cacheName = cacheConfig.getNameWithPrefix();
                ICacheRecordStore cache = this.getRecordStore(cacheName, partitionId);
                if (cache == null) continue;
                cache.clear();
                this.sendInvalidationEvent(cacheName, null, AbstractCacheRecordStore.SOURCE_NOT_AVAILABLE);
            }
        }
    }

    @Override
    protected CacheReplicationOperation newCacheReplicationOperation() {
        return new HiDensityCacheReplicationOperation();
    }

    @Override
    protected CacheOperationProvider createOperationProvider(String cacheNameWithPrefix, InMemoryFormat inMemoryFormat) {
        if (InMemoryFormat.NATIVE == inMemoryFormat) {
            return new HiDensityCacheOperationProvider(cacheNameWithPrefix);
        }
        return new EnterpriseCacheOperationProvider(cacheNameWithPrefix);
    }

    @Override
    public CacheOperationProvider getCacheOperationProvider(String cacheNameWithPrefix, InMemoryFormat inMemoryFormat) {
        CacheOperationProvider cacheOperationProvider = (CacheOperationProvider)this.operationProviderCache.get(cacheNameWithPrefix);
        if (cacheOperationProvider != null) {
            return cacheOperationProvider;
        }
        cacheOperationProvider = this.createOperationProvider(cacheNameWithPrefix, inMemoryFormat);
        CacheOperationProvider current = this.operationProviderCache.putIfAbsent(cacheNameWithPrefix, cacheOperationProvider);
        return current == null ? cacheOperationProvider : current;
    }

    private EnterpriseSerializationService getSerializationService() {
        return (EnterpriseSerializationService)this.getNodeEngine().getSerializationService();
    }

    @Override
    public HiDensityStorageInfo getOrCreateHiDensityCacheInfo(String cacheNameWithPrefix) {
        return ConcurrencyUtil.getOrPutSynchronized(this.hiDensityCacheInfoMap, cacheNameWithPrefix, this, this.hiDensityCacheInfoConstructorFunction);
    }

    @Override
    protected void additionalCacheConfigSetup(CacheConfig config, boolean existingConfig) {
        if (!existingConfig && this.hotRestartService != null && config.getHotRestartConfig().isEnabled()) {
            this.hotRestartService.ensureHasConfiguration("hz:impl:cacheService", config.getNameWithPrefix(), new PreJoinCacheConfig(config, false));
            if (config.getUserCodeNamespace() != null) {
                UserCodeNamespaceConfig namespaceConfig = ConfigAccessor.getNamespaceConfigs(this.nodeEngine.getConfig().getNamespacesConfig()).get(config.getUserCodeNamespace());
                this.hotRestartService.ensureHasConfiguration("hz:impl:namespaceService", config.getUserCodeNamespace(), namespaceConfig);
            }
        }
        this.initWanReplication(config);
    }

    private void initWanReplication(CacheConfig config) {
        WanReplicationRef wanReplicationRef = config.getWanReplicationRef();
        if (wanReplicationRef == null || wanReplicationRef.getName() == null) {
            return;
        }
        if (!this.nodeEngine.getWanReplicationService().hasWanReplicationScheme(wanReplicationRef.getName())) {
            return;
        }
        DelegatingWanScheme delegate = this.nodeEngine.getWanReplicationService().getWanReplicationPublishers(wanReplicationRef.getName());
        this.wanReplicationDelegates.putIfAbsent(config.getNameWithPrefix(), delegate);
        this.wanMergePolicies.putIfAbsent(config.getNameWithPrefix(), wanReplicationRef.getMergePolicyClassName());
    }

    @Override
    public CacheConfig deleteCacheConfig(String cacheNameWithPrefix) {
        this.wanReplicationDelegates.remove(cacheNameWithPrefix);
        return super.deleteCacheConfig(cacheNameWithPrefix);
    }

    @Override
    public void onReplicationEvent(InternalWanEvent event, WanAcknowledgeType acknowledgeType) {
        this.wanSupportingService.onReplicationEvent(event, acknowledgeType);
    }

    @Override
    public CompletionStage<Void> onSyncBatch(Collection<InternalWanEvent> batch, WanAcknowledgeType acknowledgeType) {
        return this.wanSupportingService.onSyncBatch(batch, acknowledgeType);
    }

    @Override
    public void onWanConfigChange() {
        this.getCacheConfigs().forEach(this::initWanReplication);
    }

    public void publishWanEvent(CacheEventContext cacheEventContext) {
        String cacheName = cacheEventContext.getCacheName();
        CacheEventType eventType = cacheEventContext.getEventType();
        DelegatingWanScheme wanDelegate = this.getOrLookupWanDelegate(cacheEventContext.getCacheName());
        if (wanDelegate != null && cacheEventContext.getOrigin() == null) {
            boolean backup;
            CacheConfig config = this.getCacheConfig(cacheName);
            WanReplicationRef wanReplicationRef = config.getWanReplicationRef();
            List<String> filters = EnterpriseCacheService.getFiltersFrom(wanReplicationRef);
            if (this.isEventFiltered(cacheEventContext, filters)) {
                return;
            }
            boolean bl = backup = !this.isOwnedPartition(cacheEventContext.getDataKey());
            if (eventType == CacheEventType.UPDATED || eventType == CacheEventType.CREATED || eventType == CacheEventType.EXPIRATION_TIME_UPDATED) {
                WanEnterpriseCacheAddOrUpdateEvent update = new WanEnterpriseCacheAddOrUpdateEvent(config.getName(), (String)this.wanMergePolicies.get(cacheName), new WanCacheEntryView<Object, Object>(cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), cacheEventContext.getCreationTime(), cacheEventContext.getExpirationTime(), cacheEventContext.getLastAccessTime(), cacheEventContext.getAccessHit(), this.getSerializationService()), config.getManagerPrefix(), config.getTotalBackupCount());
                if (backup) {
                    wanDelegate.publishReplicationEventBackup(update);
                } else {
                    wanDelegate.publishReplicationEvent(update);
                }
            } else if (eventType == CacheEventType.REMOVED) {
                WanEnterpriseCacheRemoveEvent remove = new WanEnterpriseCacheRemoveEvent(config.getName(), cacheEventContext.getDataKey(), config.getManagerPrefix(), config.getTotalBackupCount(), this.getSerializationService());
                if (backup) {
                    wanDelegate.publishReplicationEventBackup(remove);
                } else {
                    wanDelegate.publishReplicationEvent(remove);
                }
            }
        }
    }

    private static List<String> getFiltersFrom(WanReplicationRef wanReplicationRef) {
        if (wanReplicationRef == null) {
            return Collections.emptyList();
        }
        List<String> filters = wanReplicationRef.getFilters();
        return CollectionUtil.isEmpty(filters) ? Collections.emptyList() : filters;
    }

    private boolean isOwnedPartition(Data dataKey) {
        int partitionId = this.partitionService.getPartitionId(dataKey);
        return this.partitionService.getPartition(partitionId, false).isLocal();
    }

    private boolean isEventFiltered(CacheEventContext eventContext, List<String> filters) {
        if (!filters.isEmpty()) {
            LazyCacheEntryView entryView = new LazyCacheEntryView(eventContext.getDataKey(), eventContext.getDataValue(), eventContext.getCreationTime(), eventContext.getExpirationTime(), eventContext.getLastAccessTime(), eventContext.getAccessHit(), eventContext.getExpiryPolicy(), this.getSerializationService());
            WanFilterEventType eventType = this.convertWanFilterEventType(eventContext.getEventType());
            for (String filterName : filters) {
                CacheWanEventFilter filter = this.cacheFilterProvider.getFilter(filterName);
                if (!filter.filter(eventContext.getCacheName(), entryView, eventType)) continue;
                return true;
            }
        }
        return false;
    }

    private WanFilterEventType convertWanFilterEventType(CacheEventType eventType) {
        if (eventType == CacheEventType.REMOVED) {
            return WanFilterEventType.REMOVED;
        }
        return WanFilterEventType.UPDATED;
    }

    public void publishWanEvent(String cacheNameWithPrefix, InternalWanEvent wanEvent) {
        DelegatingWanScheme wanReplicationPublisher = this.getOrLookupWanDelegate(cacheNameWithPrefix);
        if (wanReplicationPublisher != null) {
            wanReplicationPublisher.republishReplicationEvent(wanEvent);
        }
    }

    private DelegatingWanScheme getOrLookupWanDelegate(String cacheNameWithPrefix) {
        DelegatingWanScheme delegate = (DelegatingWanScheme)this.wanReplicationDelegates.get(cacheNameWithPrefix);
        if (delegate == null) {
            DelegatingWanScheme replacedDelegate;
            CacheConfig cacheConfig = this.getCacheConfig(cacheNameWithPrefix);
            WanReplicationRef wanReplicationRef = cacheConfig.getWanReplicationRef();
            if (this.nodeEngine.getWanReplicationService().hasWanReplicationScheme(wanReplicationRef.getName())) {
                delegate = this.nodeEngine.getWanReplicationService().getWanReplicationPublishers(wanReplicationRef.getName());
            }
            if ((replacedDelegate = this.wanReplicationDelegates.putIfAbsent(cacheNameWithPrefix, delegate)) != null) {
                return replacedDelegate;
            }
        }
        return delegate;
    }

    @Override
    public void doPrepublicationChecks(String cacheNameWithPrefix) {
        DelegatingWanScheme publisher = (DelegatingWanScheme)this.wanReplicationDelegates.get(cacheNameWithPrefix);
        if (publisher != null) {
            publisher.doPrepublicationChecks();
        }
    }

    @Override
    public boolean isWanReplicationEnabled(String cacheNameWithPrefix) {
        return this.wanReplicationDelegates.get(cacheNameWithPrefix) != null && this.wanMergePolicies.get(cacheNameWithPrefix) != null;
    }

    @Override
    public CacheWanEventPublisher getCacheWanEventPublisher() {
        return this.cacheWanEventPublisher;
    }

    @Override
    public ChunkSupplier newChunkSupplier(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        if (ThreadUtil.isRunningOnPartitionThread()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Preparing cache replication operation on partition thread cannot use differential sync, partitionId %d / replicaIndex %d", event.getPartitionId(), event.getReplicaIndex()));
            }
            return super.newChunkSupplier(event, namespaces);
        }
        assert (this.assertAllKnownNamespaces(namespaces));
        Map<String, int[]> cacheNamesToMerkleDiff = this.determineDiff(event, namespaces, CacheMerkleTreePartitionCompareOperation.class.getName());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Using Merkle tree diff for %s, namespaces were %s on partition ID %d, replica index %d", cacheNamesToMerkleDiff == null ? "-" : cacheNamesToMerkleDiff.keySet(), namespaces, event.getPartitionId(), event.getReplicaIndex()));
        }
        Map<String, int[]> finalCacheNamesToMerkleDiff = cacheNamesToMerkleDiff;
        return ChunkSuppliers.newSingleChunkSupplier(() -> {
            EnterpriseCacheReplicationOperation replicationOperation = new EnterpriseCacheReplicationOperation();
            replicationOperation.setNodeEngine(this.nodeEngine);
            replicationOperation.setPartitionId(event.getPartitionId());
            replicationOperation.prepare(this.segments[event.getPartitionId()], namespaces, event.getReplicaIndex(), finalCacheNamesToMerkleDiff);
            return replicationOperation;
        });
    }

    @Nullable
    private Map<String, int[]> determineDiff(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces, String operationClassName) {
        if (event.getTarget() == null) {
            return null;
        }
        List<String> cacheNames = this.getCacheNames(event, namespaces);
        if (cacheNames.isEmpty()) {
            return null;
        }
        Map<String, int[]> cacheNamesToMerkleDiff = MerkleTreePartitionComparisonOperation.syncGetPartitionMerkleDiff(this.nodeEngine, "hz:impl:cacheService", event, cacheNames, operationClassName);
        if (MapUtil.isNullOrEmpty(cacheNamesToMerkleDiff)) {
            return null;
        }
        cacheNamesToMerkleDiff.entrySet().removeIf(entry -> entry.getValue() == MerkleTreePartitionComparisonOperation.FULL_SYNC);
        return cacheNamesToMerkleDiff;
    }

    private List<String> getCacheNames(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        ArrayList<String> cacheNames = new ArrayList<String>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            CacheConfig cacheConfig;
            String objectName = ((DistributedObjectNamespace)namespace).getObjectName();
            CachePartitionSegment segment = this.segments[event.getPartitionId()];
            ICacheRecordStore cacheRecordStore = segment.getRecordStore(objectName);
            if (cacheRecordStore == null || (cacheConfig = cacheRecordStore.getConfig()).getTotalBackupCount() < event.getReplicaIndex() || !Boolean.TRUE.equals(cacheConfig.getMerkleTreeConfig().getEnabled())) continue;
            cacheNames.add(objectName);
        }
        return cacheNames;
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        if (ThreadUtil.isRunningOnPartitionThread()) {
            return super.prepareReplicationOperation(event, namespaces);
        }
        if (this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V5_0)) {
            return super.prepareReplicationOperation(event, namespaces);
        }
        assert (this.assertAllKnownNamespaces(namespaces));
        Map<String, int[]> cacheNamesToMerkleDiff = this.determineDiff(event, namespaces, CacheMerkleTreePartitionCompareOperation.class.getName());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Using Merkle tree diff for %s, namespaces were %s on partition ID %d, replica index %d", cacheNamesToMerkleDiff == null ? "-" : cacheNamesToMerkleDiff.keySet(), namespaces, event.getPartitionId(), event.getReplicaIndex()));
        }
        EnterpriseCacheReplicationOperation replicationOperation = new EnterpriseCacheReplicationOperation();
        replicationOperation.setNodeEngine(this.nodeEngine);
        replicationOperation.setPartitionId(event.getPartitionId());
        replicationOperation.prepare(this.segments[event.getPartitionId()], namespaces, event.getReplicaIndex(), cacheNamesToMerkleDiff);
        return replicationOperation;
    }

    @Override
    public boolean shouldOffload() {
        return true;
    }

    private static final class HDStorageInfoMetricsProvider
    implements DynamicMetricsProvider {
        private final ConcurrentMap<String, HiDensityStorageInfo> hiDensityCacheInfoMap;

        private HDStorageInfoMetricsProvider(ConcurrentMap<String, HiDensityStorageInfo> hiDensityCacheInfoMap) {
            this.hiDensityCacheInfoMap = hiDensityCacheInfoMap;
        }

        @Override
        public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
            descriptor.withPrefix("cache");
            for (Map.Entry entry : this.hiDensityCacheInfoMap.entrySet()) {
                String cacheName = (String)entry.getKey();
                HiDensityStorageInfo storageInfo = (HiDensityStorageInfo)entry.getValue();
                context.collect(descriptor.copy().withDiscriminator("name", cacheName), storageInfo);
            }
        }
    }
}

