/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.config.InvalidConfigurationException;
import java.util.regex.Pattern;

final class RegionValidator {
    private static final Pattern AWS_REGION_PATTERN = Pattern.compile("aws(?:-(?:cn|us-gov|iso(?:-b)?))?-global|(?:af|ap|ca|cn|eu(?:-isoe)?|eusc-de|il|me|mx|sa|us(?:-(?:gov|iso|isob|isof))?)-(?:north(?:east|west)?|south(?:east|west)?|east|west|central)-(?:[1-5]|7)");

    private RegionValidator() {
    }

    static void validateRegion(String region) {
        if (region == null) {
            throw new InvalidConfigurationException("The provided region is null.");
        }
        if (!AWS_REGION_PATTERN.matcher(region).matches()) {
            String message = String.format("The provided region %s is not a valid AWS region.", region);
            throw new InvalidConfigurationException(message);
        }
    }
}

