/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.valid;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.LineIntersector;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.Orientation;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.PointLocation;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.RobustLineIntersector;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateArrays;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.noding.BasicSegmentString;
import com.hazelcast.shaded.org.locationtech.jts.noding.MCIndexNoder;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentString;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.PolygonIntersectionAnalyzer;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.PolygonNode;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.PolygonRing;
import java.util.ArrayList;
import java.util.List;

class PolygonTopologyAnalyzer {
    private boolean isInvertedRingValid;
    private PolygonIntersectionAnalyzer intFinder;
    private List<PolygonRing> polyRings = null;
    private Coordinate disconnectionPt = null;

    public static boolean isRingNested(LinearRing test, LinearRing target) {
        Coordinate[] targetPts;
        Coordinate p0 = test.getCoordinateN(0);
        int loc = PointLocation.locateInRing(p0, targetPts = target.getCoordinates());
        if (loc == 2) {
            return false;
        }
        if (loc == 0) {
            return true;
        }
        Coordinate p1 = PolygonTopologyAnalyzer.findNonEqualVertex(test, p0);
        return PolygonTopologyAnalyzer.isIncidentSegmentInRing(p0, p1, targetPts);
    }

    private static Coordinate findNonEqualVertex(LinearRing ring, Coordinate p) {
        int i = 1;
        Coordinate next = ring.getCoordinateN(i);
        while (next.equals2D(p) && i < ring.getNumPoints() - 1) {
            next = ring.getCoordinateN(++i);
        }
        return next;
    }

    private static boolean isIncidentSegmentInRing(Coordinate p0, Coordinate p1, Coordinate[] ringPts) {
        boolean isInteriorOnRight;
        int index = PolygonTopologyAnalyzer.intersectingSegIndex(ringPts, p0);
        if (index < 0) {
            throw new IllegalArgumentException("Segment vertex does not intersect ring");
        }
        Coordinate rPrev = PolygonTopologyAnalyzer.findRingVertexPrev(ringPts, index, p0);
        Coordinate rNext = PolygonTopologyAnalyzer.findRingVertexNext(ringPts, index, p0);
        boolean bl = isInteriorOnRight = !Orientation.isCCW(ringPts);
        if (!isInteriorOnRight) {
            Coordinate temp = rPrev;
            rPrev = rNext;
            rNext = temp;
        }
        return PolygonNode.isInteriorSegment(p0, rPrev, rNext, p1);
    }

    private static Coordinate findRingVertexPrev(Coordinate[] ringPts, int index, Coordinate node) {
        int iPrev = index;
        Coordinate prev = ringPts[iPrev];
        while (node.equals2D(prev)) {
            iPrev = PolygonTopologyAnalyzer.ringIndexPrev(ringPts, iPrev);
            prev = ringPts[iPrev];
        }
        return prev;
    }

    private static Coordinate findRingVertexNext(Coordinate[] ringPts, int index, Coordinate node) {
        int iNext = index + 1;
        Coordinate next = ringPts[iNext];
        while (node.equals2D(next)) {
            iNext = PolygonTopologyAnalyzer.ringIndexNext(ringPts, iNext);
            next = ringPts[iNext];
        }
        return next;
    }

    private static int ringIndexPrev(Coordinate[] ringPts, int index) {
        if (index == 0) {
            return ringPts.length - 2;
        }
        return index - 1;
    }

    private static int ringIndexNext(Coordinate[] ringPts, int index) {
        if (index >= ringPts.length - 2) {
            return 0;
        }
        return index + 1;
    }

    private static int intersectingSegIndex(Coordinate[] ringPts, Coordinate pt) {
        RobustLineIntersector li = new RobustLineIntersector();
        for (int i = 0; i < ringPts.length - 1; ++i) {
            ((LineIntersector)li).computeIntersection(pt, ringPts[i], ringPts[i + 1]);
            if (!li.hasIntersection()) continue;
            if (pt.equals2D(ringPts[i + 1])) {
                return i + 1;
            }
            return i;
        }
        return -1;
    }

    public static Coordinate findSelfIntersection(LinearRing ring) {
        PolygonTopologyAnalyzer ata = new PolygonTopologyAnalyzer(ring, false);
        if (ata.hasInvalidIntersection()) {
            return ata.getInvalidLocation();
        }
        return null;
    }

    public PolygonTopologyAnalyzer(Geometry geom, boolean isInvertedRingValid) {
        this.isInvertedRingValid = isInvertedRingValid;
        this.analyze(geom);
    }

    public boolean hasInvalidIntersection() {
        return this.intFinder.isInvalid();
    }

    public int getInvalidCode() {
        return this.intFinder.getInvalidCode();
    }

    public Coordinate getInvalidLocation() {
        return this.intFinder.getInvalidLocation();
    }

    public boolean isInteriorDisconnected() {
        if (this.disconnectionPt != null) {
            return true;
        }
        if (this.isInvertedRingValid) {
            this.checkInteriorDisconnectedBySelfTouch();
            if (this.disconnectionPt != null) {
                return true;
            }
        }
        this.checkInteriorDisconnectedByHoleCycle();
        return this.disconnectionPt != null;
    }

    public Coordinate getDisconnectionLocation() {
        return this.disconnectionPt;
    }

    public void checkInteriorDisconnectedByHoleCycle() {
        if (this.polyRings != null) {
            this.disconnectionPt = PolygonRing.findHoleCycleLocation(this.polyRings);
        }
    }

    public void checkInteriorDisconnectedBySelfTouch() {
        if (this.polyRings != null) {
            this.disconnectionPt = PolygonRing.findInteriorSelfNode(this.polyRings);
        }
    }

    private void analyze(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        List<SegmentString> segStrings = PolygonTopologyAnalyzer.createSegmentStrings(geom, this.isInvertedRingValid);
        this.polyRings = PolygonTopologyAnalyzer.getPolygonRings(segStrings);
        this.intFinder = this.analyzeIntersections(segStrings);
        if (this.intFinder.hasDoubleTouch()) {
            this.disconnectionPt = this.intFinder.getDoubleTouchLocation();
            return;
        }
    }

    private PolygonIntersectionAnalyzer analyzeIntersections(List<SegmentString> segStrings) {
        PolygonIntersectionAnalyzer segInt = new PolygonIntersectionAnalyzer(this.isInvertedRingValid);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(segInt);
        noder.computeNodes(segStrings);
        return segInt;
    }

    private static List<SegmentString> createSegmentStrings(Geometry geom, boolean isInvertedRingValid) {
        ArrayList<SegmentString> segStrings = new ArrayList<SegmentString>();
        if (geom instanceof LinearRing) {
            LinearRing ring = (LinearRing)geom;
            segStrings.add(PolygonTopologyAnalyzer.createSegString(ring, null));
            return segStrings;
        }
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)geom.getGeometryN(i);
            if (poly.isEmpty()) continue;
            boolean hasHoles = poly.getNumInteriorRing() > 0;
            PolygonRing shellRing = null;
            if (hasHoles || isInvertedRingValid) {
                shellRing = new PolygonRing(poly.getExteriorRing());
            }
            segStrings.add(PolygonTopologyAnalyzer.createSegString(poly.getExteriorRing(), shellRing));
            for (int j = 0; j < poly.getNumInteriorRing(); ++j) {
                LinearRing hole = poly.getInteriorRingN(j);
                if (hole.isEmpty()) continue;
                PolygonRing holeRing = new PolygonRing(hole, j, shellRing);
                segStrings.add(PolygonTopologyAnalyzer.createSegString(hole, holeRing));
            }
        }
        return segStrings;
    }

    private static List<PolygonRing> getPolygonRings(List<SegmentString> segStrings) {
        ArrayList<PolygonRing> polyRings = null;
        for (SegmentString ss : segStrings) {
            PolygonRing polyRing = (PolygonRing)ss.getData();
            if (polyRing == null) continue;
            if (polyRings == null) {
                polyRings = new ArrayList<PolygonRing>();
            }
            polyRings.add(polyRing);
        }
        return polyRings;
    }

    private static SegmentString createSegString(LinearRing ring, PolygonRing polyRing) {
        Coordinate[] pts = ring.getCoordinates();
        if (CoordinateArrays.hasRepeatedPoints(pts)) {
            pts = CoordinateArrays.removeRepeatedPoints(pts);
        }
        BasicSegmentString ss = new BasicSegmentString(pts, polyRing);
        return ss;
    }
}

