/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.edgegraph.HalfEdge;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateArrays;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateList;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTWriter;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.MaximalEdgeRing;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayEdgeRing;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayLabel;
import java.util.Comparator;

class OverlayEdge
extends HalfEdge {
    private Coordinate[] pts;
    private boolean direction;
    private Coordinate dirPt;
    private OverlayLabel label;
    private boolean isInResultArea = false;
    private boolean isInResultLine = false;
    private boolean isVisited = false;
    private OverlayEdge nextResultEdge;
    private OverlayEdgeRing edgeRing;
    private MaximalEdgeRing maxEdgeRing;
    private OverlayEdge nextResultMaxEdge;

    public static OverlayEdge createEdge(Coordinate[] pts, OverlayLabel lbl, boolean direction) {
        Coordinate dirPt;
        Coordinate origin;
        if (direction) {
            origin = pts[0];
            dirPt = pts[1];
        } else {
            int ilast = pts.length - 1;
            origin = pts[ilast];
            dirPt = pts[ilast - 1];
        }
        return new OverlayEdge(origin, dirPt, direction, lbl, pts);
    }

    public static OverlayEdge createEdgePair(Coordinate[] pts, OverlayLabel lbl) {
        OverlayEdge e0 = OverlayEdge.createEdge(pts, lbl, true);
        OverlayEdge e1 = OverlayEdge.createEdge(pts, lbl, false);
        e0.link(e1);
        return e0;
    }

    public static Comparator<OverlayEdge> nodeComparator() {
        return new Comparator<OverlayEdge>(){

            @Override
            public int compare(OverlayEdge e1, OverlayEdge e2) {
                return e1.orig().compareTo(e2.orig());
            }
        };
    }

    public OverlayEdge(Coordinate orig, Coordinate dirPt, boolean direction, OverlayLabel label, Coordinate[] pts) {
        super(orig);
        this.dirPt = dirPt;
        this.direction = direction;
        this.pts = pts;
        this.label = label;
    }

    public boolean isForward() {
        return this.direction;
    }

    @Override
    public Coordinate directionPt() {
        return this.dirPt;
    }

    public OverlayLabel getLabel() {
        return this.label;
    }

    public int getLocation(int index, int position) {
        return this.label.getLocation(index, position, this.direction);
    }

    public Coordinate getCoordinate() {
        return this.orig();
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate[] getCoordinatesOriented() {
        if (this.direction) {
            return this.pts;
        }
        Coordinate[] copy = (Coordinate[])this.pts.clone();
        CoordinateArrays.reverse(copy);
        return copy;
    }

    public void addCoordinates(CoordinateList coords) {
        boolean isFirstEdge;
        boolean bl = isFirstEdge = coords.size() > 0;
        if (this.direction) {
            int startIndex = 1;
            if (isFirstEdge) {
                startIndex = 0;
            }
            for (int i = startIndex; i < this.pts.length; ++i) {
                coords.add(this.pts[i], false);
            }
        } else {
            int startIndex = this.pts.length - 2;
            if (isFirstEdge) {
                startIndex = this.pts.length - 1;
            }
            for (int i = startIndex; i >= 0; --i) {
                coords.add(this.pts[i], false);
            }
        }
    }

    public OverlayEdge symOE() {
        return (OverlayEdge)this.sym();
    }

    public OverlayEdge oNextOE() {
        return (OverlayEdge)this.oNext();
    }

    public boolean isInResultArea() {
        return this.isInResultArea;
    }

    public boolean isInResultAreaBoth() {
        return this.isInResultArea && this.symOE().isInResultArea;
    }

    public void unmarkFromResultAreaBoth() {
        this.isInResultArea = false;
        this.symOE().isInResultArea = false;
    }

    public void markInResultArea() {
        this.isInResultArea = true;
    }

    public void markInResultAreaBoth() {
        this.isInResultArea = true;
        this.symOE().isInResultArea = true;
    }

    public boolean isInResultLine() {
        return this.isInResultLine;
    }

    public void markInResultLine() {
        this.isInResultLine = true;
        this.symOE().isInResultLine = true;
    }

    public boolean isInResult() {
        return this.isInResultArea || this.isInResultLine;
    }

    public boolean isInResultEither() {
        return this.isInResult() || this.symOE().isInResult();
    }

    void setNextResult(OverlayEdge e) {
        this.nextResultEdge = e;
    }

    public OverlayEdge nextResult() {
        return this.nextResultEdge;
    }

    public boolean isResultLinked() {
        return this.nextResultEdge != null;
    }

    void setNextResultMax(OverlayEdge e) {
        this.nextResultMaxEdge = e;
    }

    public OverlayEdge nextResultMax() {
        return this.nextResultMaxEdge;
    }

    public boolean isResultMaxLinked() {
        return this.nextResultMaxEdge != null;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    private void markVisited() {
        this.isVisited = true;
    }

    public void markVisitedBoth() {
        this.markVisited();
        this.symOE().markVisited();
    }

    public void setEdgeRing(OverlayEdgeRing edgeRing) {
        this.edgeRing = edgeRing;
    }

    public OverlayEdgeRing getEdgeRing() {
        return this.edgeRing;
    }

    public MaximalEdgeRing getEdgeRingMax() {
        return this.maxEdgeRing;
    }

    public void setEdgeRingMax(MaximalEdgeRing maximalEdgeRing) {
        this.maxEdgeRing = maximalEdgeRing;
    }

    @Override
    public String toString() {
        Coordinate orig = this.orig();
        Coordinate dest = this.dest();
        String dirPtStr = this.pts.length > 2 ? ", " + WKTWriter.format(this.directionPt()) : "";
        return "OE( " + WKTWriter.format(orig) + dirPtStr + " .. " + WKTWriter.format(dest) + " ) " + this.label.toString(this.direction) + this.resultSymbol() + " / Sym: " + this.symOE().getLabel().toString(this.symOE().direction) + this.symOE().resultSymbol();
    }

    private String resultSymbol() {
        if (this.isInResultArea) {
            return " resA";
        }
        if (this.isInResultLine) {
            return " resL";
        }
        return "";
    }
}

