/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.edgegraph;

import com.hazelcast.shaded.org.locationtech.jts.edgegraph.HalfEdge;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EdgeGraph {
    private Map vertexMap = new HashMap();

    protected HalfEdge createEdge(Coordinate orig) {
        return new HalfEdge(orig);
    }

    private HalfEdge create(Coordinate p0, Coordinate p1) {
        HalfEdge e0 = this.createEdge(p0);
        HalfEdge e1 = this.createEdge(p1);
        e0.link(e1);
        return e0;
    }

    public HalfEdge addEdge(Coordinate orig, Coordinate dest) {
        if (!EdgeGraph.isValidEdge(orig, dest)) {
            return null;
        }
        HalfEdge eAdj = (HalfEdge)this.vertexMap.get(orig);
        HalfEdge eSame = null;
        if (eAdj != null) {
            eSame = eAdj.find(dest);
        }
        if (eSame != null) {
            return eSame;
        }
        HalfEdge e = this.insert(orig, dest, eAdj);
        return e;
    }

    public static boolean isValidEdge(Coordinate orig, Coordinate dest) {
        int cmp = dest.compareTo(orig);
        return cmp != 0;
    }

    private HalfEdge insert(Coordinate orig, Coordinate dest, HalfEdge eAdj) {
        HalfEdge e = this.create(orig, dest);
        if (eAdj != null) {
            eAdj.insert(e);
        } else {
            this.vertexMap.put(orig, e);
        }
        HalfEdge eAdjDest = (HalfEdge)this.vertexMap.get(dest);
        if (eAdjDest != null) {
            eAdjDest.insert(e.sym());
        } else {
            this.vertexMap.put(dest, e.sym());
        }
        return e;
    }

    public Collection getVertexEdges() {
        return this.vertexMap.values();
    }

    public HalfEdge findEdge(Coordinate orig, Coordinate dest) {
        HalfEdge e = (HalfEdge)this.vertexMap.get(orig);
        if (e == null) {
            return null;
        }
        return e.find(dest);
    }
}

