/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.runtime;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.uzaygezen.core.BacktrackingQueryBuilder;
import com.hazelcast.shaded.com.google.uzaygezen.core.BitVector;
import com.hazelcast.shaded.com.google.uzaygezen.core.BitVectorFactories;
import com.hazelcast.shaded.com.google.uzaygezen.core.CompactHilbertCurve;
import com.hazelcast.shaded.com.google.uzaygezen.core.Content;
import com.hazelcast.shaded.com.google.uzaygezen.core.FilterCombiner;
import com.hazelcast.shaded.com.google.uzaygezen.core.FilteredIndexRange;
import com.hazelcast.shaded.com.google.uzaygezen.core.IndexCalculator;
import com.hazelcast.shaded.com.google.uzaygezen.core.LongContent;
import com.hazelcast.shaded.com.google.uzaygezen.core.PlainFilterCombiner;
import com.hazelcast.shaded.com.google.uzaygezen.core.Query;
import com.hazelcast.shaded.com.google.uzaygezen.core.RegionInspector;
import com.hazelcast.shaded.com.google.uzaygezen.core.SimpleRegionInspector;
import com.hazelcast.shaded.com.google.uzaygezen.core.SpaceVisitor;
import com.hazelcast.shaded.com.google.uzaygezen.core.ZoomingNavigator;
import com.hazelcast.shaded.com.google.uzaygezen.core.ZoomingSpaceVisitorAdapter;
import com.hazelcast.shaded.com.google.uzaygezen.core.ranges.LongRange;
import com.hazelcast.shaded.com.google.uzaygezen.core.ranges.LongRangeHome;
import com.hazelcast.shaded.com.google.uzaygezen.core.ranges.RangeHome;
import com.hazelcast.shaded.org.apache.calcite.runtime.SpaceFillingCurve2D;
import java.util.ArrayList;
import java.util.List;

public class HilbertCurve2D
implements SpaceFillingCurve2D {
    final long precision;
    final CompactHilbertCurve chc;
    private final int resolution;

    public HilbertCurve2D(int resolution) {
        this.resolution = resolution;
        this.precision = (long)Math.pow(2.0, resolution);
        this.chc = new CompactHilbertCurve(new int[]{resolution, resolution});
    }

    long getNormalizedLongitude(double x) {
        return (long)((x + 180.0) * (double)(this.precision - 1L) / 360.0);
    }

    long getNormalizedLatitude(double y) {
        return (long)((y + 90.0) * (double)(this.precision - 1L) / 180.0);
    }

    long setNormalizedLatitude(long latNormal) {
        if (latNormal < 0L || latNormal > this.precision) {
            throw new NumberFormatException("Normalized latitude must be greater than 0 and less than the maximum precision");
        }
        return (long)((double)latNormal * 180.0 / (double)(this.precision - 1L));
    }

    long setNormalizedLongitude(long lonNormal) {
        if (lonNormal < 0L || lonNormal > this.precision) {
            throw new NumberFormatException("Normalized longitude must be greater than 0 and less than the maximum precision");
        }
        return (long)((double)lonNormal * 360.0 / (double)(this.precision - 1L));
    }

    @Override
    public long toIndex(double x, double y) {
        long normX = this.getNormalizedLongitude(x);
        long normY = this.getNormalizedLatitude(y);
        BitVector[] p = new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply((Object)this.resolution), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)this.resolution)};
        p[0].copyFrom(normX);
        p[1].copyFrom(normY);
        BitVector hilbert = (BitVector)BitVectorFactories.OPTIMAL.apply((Object)(this.resolution * 2));
        this.chc.index(p, 0, hilbert);
        return hilbert.toLong();
    }

    @Override
    public SpaceFillingCurve2D.Point toPoint(long i) {
        BitVector h2 = (BitVector)BitVectorFactories.OPTIMAL.apply((Object)(this.resolution * 2));
        h2.copyFrom(i);
        BitVector[] p = new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply((Object)this.resolution), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)this.resolution)};
        this.chc.indexInverse(h2, p);
        long x = this.setNormalizedLongitude(p[0].toLong()) - 180L;
        long y = this.setNormalizedLatitude(p[1].toLong()) - 90L;
        return new SpaceFillingCurve2D.Point(x, y);
    }

    @Override
    public List<SpaceFillingCurve2D.IndexRange> toRanges(double xMin, double yMin, double xMax, double yMax, SpaceFillingCurve2D.RangeComputeHints hints) {
        CompactHilbertCurve chc = new CompactHilbertCurve(new int[]{this.resolution, this.resolution});
        ArrayList<LongRange> region = new ArrayList<LongRange>();
        long minNormalizedLongitude = this.getNormalizedLongitude(xMin);
        long minNormalizedLatitude = this.getNormalizedLatitude(yMin);
        long maxNormalizedLongitude = this.getNormalizedLongitude(xMax);
        long maxNormalizedLatitude = this.getNormalizedLatitude(yMax);
        region.add(LongRange.of((long)minNormalizedLongitude, (long)maxNormalizedLongitude));
        region.add(LongRange.of((long)minNormalizedLatitude, (long)maxNormalizedLatitude));
        LongContent zero = new LongContent(0L);
        SimpleRegionInspector inspector = SimpleRegionInspector.create(ImmutableList.of(region), (Content)new LongContent(1L), range -> range, (RangeHome)LongRangeHome.INSTANCE, (Content)zero);
        PlainFilterCombiner combiner = new PlainFilterCombiner((Object)LongRange.of((long)0L, (long)1L));
        BacktrackingQueryBuilder queryBuilder = BacktrackingQueryBuilder.create((RegionInspector)inspector, (FilterCombiner)combiner, (int)Integer.MAX_VALUE, (boolean)true, (RangeHome)LongRangeHome.INSTANCE, (Content)zero);
        chc.accept((ZoomingNavigator)new ZoomingSpaceVisitorAdapter((IndexCalculator)chc, (SpaceVisitor)queryBuilder));
        Query query = queryBuilder.get();
        List ranges = query.getFilteredIndexRanges();
        ArrayList<SpaceFillingCurve2D.IndexRange> result = new ArrayList<SpaceFillingCurve2D.IndexRange>();
        for (FilteredIndexRange l : ranges) {
            LongRange range2 = (LongRange)l.getIndexRange();
            Long start = range2.getStart();
            Long end = range2.getEnd();
            boolean contained = l.isPotentialOverSelectivity();
            result.add(0, SpaceFillingCurve2D.IndexRanges.create(start, end, contained));
        }
        return result;
    }
}

