/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.math;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.NumericOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonotonicity;

public final class HazelcastFloorCeilFunction
extends HazelcastFunction {
    public static final SqlFunction FLOOR = new HazelcastFloorCeilFunction(SqlKind.FLOOR);
    public static final SqlFunction CEIL = new HazelcastFloorCeilFunction(SqlKind.CEIL);

    private HazelcastFloorCeilFunction(SqlKind kind) {
        super(kind.name(), kind, ReturnTypes.ARG0_OR_EXACT_NO_SCALE, new ReplaceUnknownOperandTypeInference(SqlTypeName.DECIMAL), SqlFunctionCategory.NUMERIC);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        return NumericOperandChecker.INSTANCE.check(binding, throwOnFailure, 0);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0).unstrict();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        if (call.operandCount() == 2) {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 100);
            writer.sep("TO");
            ((SqlNode)call.operand(1)).unparse(writer, 100, 0);
        } else {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        }
        writer.endFunCall(frame);
    }
}

