/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.json;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.QueryException;

public class HazelcastJsonObjectFunction
extends HazelcastFunction {
    public static final HazelcastJsonObjectFunction INSTANCE = new HazelcastJsonObjectFunction();

    protected HazelcastJsonObjectFunction() {
        super("JSON_OBJECT", SqlKind.OTHER_FUNCTION, opBinding -> HazelcastJsonType.create(false), new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY), SqlFunctionCategory.SYSTEM);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        if (callBinding.getOperandCount() % 2 != 1) {
            throw QueryException.error((int)1008, (String)"Unexpected number of arguments to JSON_OBJECT");
        }
        boolean isValid = TypedOperandChecker.SYMBOL.check(callBinding, throwOnFailure, 0);
        for (int i = 1; isValid && i < callBinding.getOperandCount(); i += 2) {
            isValid = TypedOperandChecker.VARCHAR.check(callBinding, false, i);
            if (isValid || !throwOnFailure) continue;
            throw QueryException.error((int)1008, (String)"The type of keys must be VARCHAR");
        }
        return isValid;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        if (call.operandCount() == 1) {
            writer.endFunCall(frame);
            return;
        }
        for (int i = 1; i < call.operandCount(); i += 2) {
            writer.sep(",");
            writer.keyword("KEY");
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
            writer.keyword("VALUE");
            ((SqlNode)call.operand(i + 1)).unparse(writer, leftPrec, rightPrec);
        }
        SqlJsonConstructorNullClause nullClause = (SqlJsonConstructorNullClause)((Object)((SqlLiteral)call.operand(0)).getValue());
        switch (nullClause) {
            case ABSENT_ON_NULL: {
                writer.keyword("ABSENT ON NULL");
                break;
            }
            case NULL_ON_NULL: {
                writer.keyword("NULL ON NULL");
                break;
            }
            default: {
                throw QueryException.error((String)("Unknown SqlJsonConstructorNullClause constant: " + String.valueOf((Object)nullClause)));
            }
        }
        writer.endFunCall(frame);
    }
}

