/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlShowStatement
extends SqlCall {
    public static final SqlSpecialOperator SHOW_MAPPINGS = new SqlSpecialOperator("SHOW EXTERNAL MAPPINGS", SqlKind.OTHER);
    public static final SqlSpecialOperator SHOW_VIEWS = new SqlSpecialOperator("SHOW VIEWS", SqlKind.OTHER);
    public static final SqlSpecialOperator SHOW_JOBS = new SqlSpecialOperator("SHOW JOBS", SqlKind.OTHER);
    public static final SqlSpecialOperator SHOW_TYPES = new SqlSpecialOperator("SHOW TYPES", SqlKind.OTHER);
    public static final SqlSpecialOperator SHOW_DATA_CONNECTIONS = new SqlSpecialOperator("SHOW DATA CONNECTIONS", SqlKind.OTHER);
    public static final SqlSpecialOperator SHOW_RESOURCES = new SqlSpecialOperator("SHOW RESOURCES FOR", SqlKind.OTHER);
    private final ShowStatementTarget target;
    private final SqlIdentifier dataConnectionName;

    public SqlShowStatement(SqlParserPos pos, @Nonnull ShowStatementTarget target, @Nullable SqlIdentifier dataConnectionName) {
        super(pos);
        this.target = target;
        this.dataConnectionName = dataConnectionName;
        assert (dataConnectionName == null || target == ShowStatementTarget.RESOURCES);
    }

    public ShowStatementTarget getTarget() {
        return this.target;
    }

    @Nullable
    public String getDataConnectionNameWithoutSchema() {
        return this.dataConnectionName != null && ValidationUtil.isCatalogObjectNameValid(this.dataConnectionName) ? (String)this.dataConnectionName.names.get(this.dataConnectionName.names.size() - 1) : null;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return this.target.operator;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        if (this.dataConnectionName != null) {
            return ImmutableNullableList.of(this.dataConnectionName);
        }
        return Collections.emptyList();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.target.operator.getName());
        if (this.target.operator.equals(SHOW_RESOURCES) && this.dataConnectionName != null) {
            writer.keyword("FOR");
            this.dataConnectionName.unparse(writer, leftPrec, rightPrec);
        }
    }

    public static enum ShowStatementTarget {
        MAPPINGS(SHOW_MAPPINGS),
        VIEWS(SHOW_VIEWS),
        JOBS(SHOW_JOBS),
        TYPES(SHOW_TYPES),
        DATACONNECTIONS(SHOW_DATA_CONNECTIONS),
        RESOURCES(SHOW_RESOURCES);

        private final SqlSpecialOperator operator;

        private ShowStatementTarget(SqlSpecialOperator operator) {
            this.operator = operator;
        }
    }
}

