/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.AggregateLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.CalcLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.SlidingWindowLogicalRel;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.opt.metadata.WatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAbstractPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableAggregateSlidingWindowPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.ShouldNotExecuteRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Calc;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public final class AggregateSlidingWindowPhysicalRule
extends AggregateAbstractPhysicalRule {
    static final RelOptRule NO_CALC_INSTANCE = new AggregateSlidingWindowPhysicalRule(Config.CONFIG_NO_CALC, false);
    static final RelOptRule WITH_CALC_INSTANCE = new AggregateSlidingWindowPhysicalRule(Config.CONFIG_WITH_CALC, true);
    private final boolean hasCalc;

    private AggregateSlidingWindowPhysicalRule(Config config, boolean hasCalc) {
        super(config);
        this.hasCalc = hasCalc;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SlidingWindowLogicalRel windowRel;
        RelDataType projectRowType;
        ArrayList<RexNode> projections;
        RexProgram program;
        AggregateLogicalRel logicalAggregate = (AggregateLogicalRel)call.rel(0);
        assert (logicalAggregate.getGroupType() == Aggregate.Group.SIMPLE);
        assert (logicalAggregate.getGroupSets().size() == 1 && (logicalAggregate.getGroupSet() == null || logicalAggregate.getGroupSet().equals(logicalAggregate.getGroupSets().get(0))));
        if (this.hasCalc) {
            Calc calc = (Calc)call.rel(1);
            program = calc.getProgram();
            projections = new ArrayList<RexNode>(program.expandList(program.getProjectList()));
            projectRowType = calc.getProgram().getOutputRowType();
            windowRel = (SlidingWindowLogicalRel)call.rel(2);
        } else {
            windowRel = (SlidingWindowLogicalRel)call.rel(1);
            program = RexProgram.createIdentity(windowRel.getRowType());
            projectRowType = program.getOutputRowType();
            projections = new ArrayList<RexNode>(program.expandList(program.getProjectList()));
        }
        int timestampIndex = windowRel.orderingFieldIndex();
        int windowStartIndex = windowRel.windowStartIndex();
        int windowEndIndex = windowRel.windowEndIndex();
        ArrayList<Integer> windowStartIndexes = new ArrayList<Integer>();
        ArrayList<Integer> windowEndIndexes = new ArrayList<Integer>();
        for (int i = 0; i < projections.size(); ++i) {
            RexNode projection = (RexNode)projections.get(i);
            if (projection instanceof RexInputRef) {
                int index = ((RexInputRef)projection).getIndex();
                if (index != windowStartIndex && index != windowEndIndex) continue;
                projection = call.builder().getRexBuilder().makeInputRef(projection.getType(), timestampIndex);
                projections.set(i, projection);
                if (index == windowStartIndex) {
                    windowStartIndexes.add(i);
                    continue;
                }
                windowEndIndexes.add(i);
                continue;
            }
            if (!OptUtils.hasInputRef(projection, windowStartIndex, windowEndIndex)) continue;
            throw QueryException.error((int)1008, (String)"In window aggregation, the window_start and window_end fields must be used directly, without any transformation");
        }
        RelNode input = windowRel.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = OptUtils.extractPhysicalRelsFromSubset(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            program = RexProgram.create(convertedInput.getRowType(), projections, program.getCondition() != null ? program.expandLocalRef(program.getCondition()) : null, projectRowType, call.builder().getRexBuilder());
            CalcPhysicalRel newCalc = new CalcPhysicalRel(transformedInput.getCluster(), transformedInput.getTraitSet(), transformedInput, program);
            RelNode transformedRel = this.transform(newCalc, logicalAggregate, windowStartIndexes, windowEndIndexes, windowRel.windowPolicyProvider());
            if (transformedRel != null) {
                call.transformTo(transformedRel);
                continue;
            }
            call.transformTo(new ShouldNotExecuteRel(logicalAggregate.getCluster(), OptUtils.toPhysicalConvention(logicalAggregate.getTraitSet()), logicalAggregate.getRowType(), "Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)"));
        }
    }

    private RelNode transform(RelNode physicalInput, AggregateLogicalRel logicalAggregate, List<Integer> windowStartIndexes, List<Integer> windowEndIndexes, FunctionEx<ExpressionEvalContext, SlidingWindowPolicy> windowPolicyProvider) {
        Integer watermarkedField = AggregateSlidingWindowPhysicalRule.findWatermarkedField(logicalAggregate, windowStartIndexes, windowEndIndexes, physicalInput);
        if (watermarkedField == null) {
            return null;
        }
        return new SlidingWindowAggregatePhysicalRel(physicalInput.getCluster(), physicalInput.getTraitSet(), physicalInput, logicalAggregate.getGroupSet(), logicalAggregate.getGroupSets(), logicalAggregate.getAggCallList(), watermarkedField, windowPolicyProvider, logicalAggregate.containsDistinctCall() ? 1 : 2, windowStartIndexes, windowEndIndexes);
    }

    @Nullable
    private static Integer findWatermarkedField(AggregateLogicalRel logicalAggregate, List<Integer> windowStartIndexes, List<Integer> windowEndIndexes, RelNode input) {
        HazelcastRelMetadataQuery query = OptUtils.metadataQuery(input);
        WatermarkedFields watermarkedFields = query.extractWatermarkedFields(input);
        if (watermarkedFields == null) {
            return null;
        }
        ImmutableBitSet.Builder windowBoundIndexesBuilder = ImmutableBitSet.builder().addAll(windowStartIndexes).addAll(windowEndIndexes);
        windowBoundIndexesBuilder.intersect(logicalAggregate.getGroupSet());
        return watermarkedFields.findFirst(windowBoundIndexesBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config CONFIG_WITH_CALC = ImmutableAggregateSlidingWindowPhysicalRule.Config.builder().description(AggregateSlidingWindowPhysicalRule.class.getSimpleName() + "-project").operandSupplier(b0 -> b0.operand(AggregateLogicalRel.class).trait(Conventions.LOGICAL).predicate(OptUtils::isUnbounded).inputs(b1 -> b1.operand(CalcLogicalRel.class).inputs(b2 -> b2.operand(SlidingWindowLogicalRel.class).anyInputs()))).build();
        public static final Config CONFIG_NO_CALC = ImmutableAggregateSlidingWindowPhysicalRule.Config.builder().description(AggregateSlidingWindowPhysicalRule.class.getSimpleName() + "-no-project").operandSupplier(b0 -> b0.operand(AggregateLogicalRel.class).trait(Conventions.LOGICAL).predicate(OptUtils::isUnbounded).inputs(b1 -> b1.operand(SlidingWindowLogicalRel.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            throw new UnsupportedOperationException();
        }
    }
}

