/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.SlidingWindow;
import com.hazelcast.jet.sql.impl.opt.logical.CalcLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ImmutableSlidingWindowCalcSplitLogicalRule;
import com.hazelcast.jet.sql.impl.opt.logical.MustNotExecuteLogicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitorImpl;
import java.util.Collections;
import org.immutables.value.Value;

@Value.Enclosing
public class SlidingWindowCalcSplitLogicalRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final RelOptRule STREAMING_FILTER_TRANSPOSE = new SlidingWindowCalcSplitLogicalRule(Config.DEFAULT);

    protected SlidingWindowCalcSplitLogicalRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        CalcLogicalRel calc = (CalcLogicalRel)call.rel(0);
        final SlidingWindow sw = (SlidingWindow)call.rel(1);
        final boolean[] mustNotExecute = new boolean[]{false};
        RexProgram program = calc.getProgram();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef ref) {
                int index = ref.getIndex();
                if (index == sw.windowStartIndex() || index == sw.windowEndIndex()) {
                    mustNotExecute[0] = true;
                }
                return (Void)super.visitInputRef(ref);
            }
        };
        program.expandLocalRef(program.getCondition()).accept(visitor);
        if (mustNotExecute[0]) {
            call.transformTo(new MustNotExecuteLogicalRel(sw.getCluster(), sw.getTraitSet(), program.getOutputRowType(), "Can't apply filter criteria to window bounds"));
            return;
        }
        RexProgramBuilder programBuilder = new RexProgramBuilder(sw.getInput().getRowType(), sw.getCluster().getRexBuilder());
        programBuilder.clearCondition();
        programBuilder.addCondition(program.expandLocalRef(program.getCondition()));
        programBuilder.addIdentity();
        RexProgram identityProgram = programBuilder.getProgram();
        CalcLogicalRel filterCalc = new CalcLogicalRel(calc.getCluster(), sw.getTraitSet(), calc.getHints(), sw.getInput(), identityProgram);
        RexProgramBuilder builder = RexProgramBuilder.forProgram(program, calc.getCluster().getRexBuilder(), true);
        builder.clearCondition();
        SlidingWindow topSW = (SlidingWindow)sw.copy(sw.getTraitSet(), Collections.singletonList(filterCalc));
        CalcLogicalRel newCalc = (CalcLogicalRel)calc.copy(calc.getTraitSet(), topSW, builder.getProgram());
        call.transformTo(newCalc);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSlidingWindowCalcSplitLogicalRule.Config.builder().description(SlidingWindowCalcSplitLogicalRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(CalcLogicalRel.class).predicate(calc -> calc.getProgram().getCondition() != null).trait(Conventions.LOGICAL).inputs(b1 -> b1.operand(SlidingWindow.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new SlidingWindowCalcSplitLogicalRule(this);
        }
    }
}

