/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.expression.json.JsonPathUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.jsfr.json.path.JsonPath;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.ConcurrentInitialSetCache;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.VariExpressionWithType;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;

public class JsonValueFunction<T>
extends VariExpressionWithType<T> {
    private static final ILogger LOGGER = Logger.getLogger(JsonValueFunction.class);
    private static final int DEFAULT_ON_EMPTY_OPERAND_INDEX = 2;
    private static final int DEFAULT_ON_ERROR_OPERAND_INDEX = 3;
    private static final Function<String, JsonPath> COMPILE_FUNCTION = JsonPathUtil::compile;
    private transient ConcurrentInitialSetCache<String, JsonPath> pathCache;
    private JsonPath constantPathCache;
    private SqlJsonValueEmptyOrErrorBehavior onEmpty;
    private SqlJsonValueEmptyOrErrorBehavior onError;

    public JsonValueFunction() {
    }

    private JsonValueFunction(Expression<?>[] operands, QueryDataType resultType, SqlJsonValueEmptyOrErrorBehavior onEmpty, SqlJsonValueEmptyOrErrorBehavior onError) {
        super(operands, resultType);
        this.onEmpty = onEmpty;
        this.onError = onError;
        this.prepareCache();
    }

    public static JsonValueFunction<?> create(Expression<?> json, Expression<?> path, Expression<?> defaultValueOnEmpty, Expression<?> defaultValueOnError, QueryDataType resultType, SqlJsonValueEmptyOrErrorBehavior onEmpty, SqlJsonValueEmptyOrErrorBehavior onError) {
        Expression[] operands = new Expression[]{json, path, defaultValueOnEmpty, defaultValueOnError};
        return new JsonValueFunction(operands, resultType, onEmpty, onError);
    }

    public int getClassId() {
        return 2;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Collection<Object> resultColl;
        String json;
        String path = (String)this.operands[1].eval(row, context);
        this.validatePath(path);
        Object operand0 = this.operands[0].eval(row, context);
        String string = json = operand0 instanceof HazelcastJsonValue ? operand0.toString() : (String)operand0;
        if (json == null) {
            json = "";
        }
        JsonPath jsonPath = this.constantPathCache != null ? this.constantPathCache : this.pathCache.computeIfAbsent(path, COMPILE_FUNCTION);
        try {
            resultColl = JsonPathUtil.read(json, jsonPath);
        }
        catch (Exception e) {
            return this.onErrorResponse(e, row, context);
        }
        if (resultColl.isEmpty()) {
            return this.onEmptyResponse(row, context);
        }
        if (resultColl.size() > 1) {
            throw QueryException.error((String)"JSON_VALUE evaluated to multiple values");
        }
        Object onlyResult = resultColl.iterator().next();
        if (JsonPathUtil.isArrayOrObject(onlyResult)) {
            return this.onErrorResponse((Exception)QueryException.error((String)"Result of JSON_VALUE cannot be array or object"), row, context);
        }
        Object result = this.convertResultType(onlyResult);
        return (T)result;
    }

    private void prepareCache() {
        if (this.operands[1] instanceof ConstantExpression) {
            String path = (String)this.operands[1].eval(null, null);
            this.validatePath(path);
            this.constantPathCache = JsonPathUtil.compile(path);
        } else {
            this.pathCache = JsonPathUtil.makePathCache();
        }
    }

    private void validatePath(String path) {
        if (path == null) {
            throw QueryException.error((String)"SQL/JSON path expression cannot be null");
        }
    }

    private T onEmptyResponse(Row row, ExpressionEvalContext context) {
        switch (this.onEmpty) {
            case ERROR: {
                throw QueryException.error((String)"JSON_VALUE evaluated to no value");
            }
            case DEFAULT: {
                return this.operands[2].eval(row, context);
            }
        }
        return null;
    }

    private T onErrorResponse(Exception exception, Row row, ExpressionEvalContext context) {
        switch (this.onError) {
            case ERROR: {
                LOGGER.fine("JSON_VALUE failed", (Throwable)exception);
                throw QueryException.error((String)("JSON_VALUE failed: " + String.valueOf(exception)));
            }
            case DEFAULT: {
                return this.operands[3].eval(row, context);
            }
        }
        return null;
    }

    private Object convertResultType(Object result) {
        if (result == null) {
            return null;
        }
        if (this.resultType.getTypeFamily().equals((Object)QueryDataTypeFamily.VARCHAR)) {
            return result.toString();
        }
        Converter converter = Converters.getConverter(result.getClass());
        switch (this.resultType.getTypeFamily().getPublicType()) {
            case TINYINT: {
                return converter.asTinyint(result);
            }
            case SMALLINT: {
                return converter.asSmallint(result);
            }
            case INTEGER: {
                return converter.asInt(result);
            }
            case BIGINT: {
                return converter.asBigint(result);
            }
            case REAL: {
                return Float.valueOf(converter.asReal(result));
            }
            case DOUBLE: {
                return converter.asDouble(result);
            }
            case DECIMAL: {
                return converter.asDecimal(result);
            }
            case TIMESTAMP: {
                return converter.asTimestamp(result);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return converter.asTimestampWithTimezone(result);
            }
            case DATE: {
                return converter.asDate(result);
            }
            case TIME: {
                return converter.asTime(result);
            }
        }
        return result;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.onEmpty.name());
        out.writeString(this.onError.name());
        out.writeObject((Object)this.constantPathCache);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.onEmpty = SqlJsonValueEmptyOrErrorBehavior.valueOf(in.readString());
        this.onError = SqlJsonValueEmptyOrErrorBehavior.valueOf(in.readString());
        this.constantPathCache = (JsonPath)in.readObject();
        if (this.constantPathCache == null) {
            this.pathCache = JsonPathUtil.makePathCache();
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        if (this.constantPathCache == null) {
            this.pathCache = JsonPathUtil.makePathCache();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.onEmpty, this.onError);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JsonValueFunction that = (JsonValueFunction)o;
        return this.onEmpty.equals(that.onEmpty) && this.onError.equals(that.onError);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{operand=" + Arrays.toString(this.operands) + ", resultType=" + String.valueOf(this.resultType) + ", onEmpty=" + this.onEmpty.name() + ", onError=" + this.onError.name() + "}";
    }
}

