/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public final class ObjectArrayKey
implements DataSerializable {
    private Data[] keyFields;

    private ObjectArrayKey() {
    }

    private ObjectArrayKey(Data[] keyFields) {
        this.keyFields = keyFields;
    }

    public boolean containsNull() {
        for (Data o : this.keyFields) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.keyFields.length);
        for (Data field : this.keyFields) {
            IOUtil.writeData((ObjectDataOutput)out, (Data)field);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.keyFields = new Data[size];
        for (int i = 0; i < size; ++i) {
            this.keyFields[i] = IOUtil.readData((ObjectDataInput)in);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectArrayKey that = (ObjectArrayKey)o;
        return Arrays.equals(this.keyFields, that.keyFields);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyFields);
    }

    public static ObjectArrayKey project(JetSqlRow row, int[] indices) {
        Data[] key = new Data[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            key[i] = row.getSerialized(indices[i]);
        }
        return new ObjectArrayKey(key);
    }

    public static FunctionEx<JetSqlRow, ObjectArrayKey> projectFn(int[] indices) {
        return (FunctionEx & Serializable)row -> ObjectArrayKey.project(row, indices);
    }
}

