/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.vector.impl.storage.VectorKeysEntry;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public final class VectorMultiKeysEntry
implements VectorKeysEntry {
    private final Collection<Data> keys = new CopyOnWriteArrayList<Data>();

    private VectorMultiKeysEntry() {
    }

    @Override
    public VectorKeysEntry addKey(Data key) {
        this.keys.add(key);
        return this;
    }

    @Override
    public void deleteKey(Data key) {
        this.keys.remove(key);
    }

    @Override
    public boolean isEmptyKeys() {
        return this.keys.isEmpty();
    }

    @Override
    public int forEachKeyWithLimit(int limit, Consumer<Data> action) {
        int counter = 0;
        for (Data key : this.keys) {
            if (counter == limit) break;
            action.accept(key);
            ++counter;
        }
        return counter;
    }

    public static VectorMultiKeysEntry create() {
        return new VectorMultiKeysEntry();
    }
}

