/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.stats;

import com.hazelcast.internal.memory.Measurable;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.impl.service.VectorCollectionServiceImpl;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStatsImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class LocalVectorCollectionStatsProvider
implements DynamicMetricsProvider,
Measurable {
    public static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    public static final long ENTRY_HEAP_BYTES_USED = (long)JVMUtil.REFERENCE_COST_IN_BYTES * 2L + LocalVectorCollectionStatsImpl.FIXED_HEAP_BYTES_USED;
    private static final ConstructorFunction<String, LocalVectorCollectionStatsImpl> CONSTRUCTOR_FUNCTION = name -> new LocalVectorCollectionStatsImpl();
    private final ConcurrentMap<String, LocalVectorCollectionStatsImpl> statsMap;
    private final VectorCollectionService service;

    public LocalVectorCollectionStatsProvider(NodeEngine nodeEngine, VectorCollectionServiceImpl service) {
        this.service = service;
        this.statsMap = MapUtil.createConcurrentHashMap(nodeEngine.getConfig().getVectorCollectionConfigs().size());
    }

    public LocalVectorCollectionStatsImpl getStatistics(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, CONSTRUCTOR_FUNCTION);
    }

    public boolean hasStatistics(String name) {
        return this.statsMap.containsKey(name);
    }

    public void destroyStatistics(String name) {
        this.statsMap.remove(name);
    }

    public void reset() {
        this.statsMap.clear();
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        for (Map.Entry entry : this.statsMap.entrySet()) {
            String name = (String)entry.getKey();
            LocalVectorCollectionStatsImpl localInstanceStats = (LocalVectorCollectionStatsImpl)entry.getValue();
            localInstanceStats.setOwnedEntryCount(this.service.localSize(name));
            long heapCost = this.service.heapBytesUsed(name);
            localInstanceStats.setHeapCost(heapCost);
            localInstanceStats.setOwnedEntryHeapMemoryCost(heapCost);
            MetricDescriptor dsDescriptor = descriptor.copy().withPrefix("vectorCollection").withDiscriminator("name", name);
            context.collect(dsDescriptor, localInstanceStats);
        }
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + (long)this.statsMap.size() * ENTRY_HEAP_BYTES_USED;
    }
}

