/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.query;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.operations.OperationFactoryWrapper;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.ops.SearchOperationsFactory;
import com.hazelcast.vector.impl.query.QueryResult;
import com.hazelcast.vector.impl.query.Searcher;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class SingleStageSearcher
implements Searcher {
    public static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    private final IPartitionService partitionService;
    private final OperationService operationService;

    public SingleStageSearcher(NodeEngine engine) {
        this.partitionService = engine.getPartitionService();
        this.operationService = engine.getOperationService();
    }

    @Override
    public CompletableFuture<SearchResults<Data, Data>> search(String collectionName, VectorValues vectors, SearchOptions options, @Nullable ClientEndpoint endpoint) {
        SearchOperationsFactory searchFactory = new SearchOperationsFactory(collectionName, vectors, options);
        OperationFactory operationFactory = endpoint != null ? new OperationFactoryWrapper(searchFactory, endpoint.getUuid()) : searchFactory;
        return this.operationService.invokeOnAllPartitionsAsync("hz:service:vector", operationFactory).thenApplyAsync(map -> QueryResult.reduce(map, options, this.partitionService.getPartitionCount()), ConcurrencyUtil.CALLER_RUNS);
    }
}

