/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionSearchNearVectorCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.security.permission.VectorCollectionPermission;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorCollectionService;
import java.security.Permission;
import java.util.concurrent.CompletableFuture;

public class VectorCollectionSearchNearVectorMessageTask
extends AbstractAsyncMessageTask<VectorCollectionSearchNearVectorCodec.RequestParameters, SearchResults<Data, Data>> {
    private transient long startTimeNanos;

    VectorCollectionSearchNearVectorMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected VectorCollectionSearchNearVectorCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return VectorCollectionSearchNearVectorCodec.decodeRequest(clientMessage);
    }

    @Override
    protected void beforeProcess() {
        this.startTimeNanos = Timer.nanos();
    }

    @Override
    protected Object processResponseBeforeSending(SearchResults<Data, Data> response) {
        VectorCollectionService service = (VectorCollectionService)this.getService("hz:service:vector");
        service.getStatistics(this.getDistributedObjectName()).incrementSearchLatencyNanos(response.size(), Timer.nanosElapsed(this.startTimeNanos));
        return response;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        SearchResults results = (SearchResults)response;
        return VectorCollectionSearchNearVectorCodec.encodeResponse(() -> results.results());
    }

    @Override
    protected CompletableFuture<SearchResults<Data, Data>> processInternal() {
        VectorCollectionService service = (VectorCollectionService)this.getService("hz:service:vector");
        return service.getSearcher(((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).name, ((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).options).search(((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).name, CustomTypeFactory.toVectorValues(((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).vectors), ((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).options, this.endpoint);
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public String getDistributedObjectName() {
        return ((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "search";
    }

    @Override
    public Permission getRequiredPermission() {
        return new VectorCollectionPermission(this.getDistributedObjectName(), "read");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{CustomTypeFactory.toVectorValues(((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).vectors), ((VectorCollectionSearchNearVectorCodec.RequestParameters)this.parameters).options};
    }
}

