/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.SearchResultsImpl;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;

public class SearchOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable,
ReadonlyOperation,
SelfResponseOperation {
    private VectorValues vectors;
    private SearchOptions searchOptions;
    private transient SearchResults<Data, Data> result;

    public SearchOperation() {
    }

    public SearchOperation(String vectorCollectionName, VectorValues vectors, SearchOptions searchOptions) {
        super(vectorCollectionName);
        this.vectors = vectors;
        this.searchOptions = searchOptions;
    }

    @Override
    public CallStatus call() {
        VectorCollectionService service = (VectorCollectionService)this.getService();
        final VectorCollectionStorage maybeStorage = service.getStorageOrNull(this.getName(), this.getPartitionId());
        if (maybeStorage != null) {
            return new Offload(this){

                @Override
                public void start() {
                    ManagedExecutorService executor = SearchOperation.this.getNodeEngine().getExecutionService().getExecutor("hz:query");
                    executor.execute(() -> {
                        try {
                            SearchOperation.this.sendResponse(maybeStorage.search(SearchOperation.this.vectors, SearchOperation.this.searchOptions));
                        }
                        catch (Throwable e) {
                            SearchOperation.this.sendResponse(e);
                        }
                    });
                }
            };
        }
        this.result = SearchResultsImpl.EMPTY;
        return CallStatus.RESPONSE;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.vectors);
        out.writeObject(this.searchOptions);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.vectors = (VectorValues)in.readObject();
        this.searchOptions = (SearchOptions)in.readObject();
    }
}

